/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.text;

import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import jp.sourceforge.f77editorplugin.text.Activator;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public class Images {
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("jp.sourceforge.f77editorplugin.text.images");
    private static ImageRegistry imageRegistry = new ImageRegistry();

    public static Image getImage(String path) {
        if (path == null) {
            return null;
        }
        Image img = imageRegistry.get(path);
        if (img == null) {
            try {
                URL location = FileLocator.toFileURL((URL)Activator.getDefault().getBundle().getEntry(path));
                ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)location);
                imageRegistry.put(path, descriptor);
                img = descriptor.createImage();
            }
            catch (IOException iOException) {}
        }
        return img;
    }

    public static Image getIconImage(String key) {
        return Images.getImage(Images.getIconPath(key));
    }

    public static Image getIconImage(String key, String defaultKey) {
        return Images.getImage(Images.getIconPath(key, defaultKey));
    }

    public static String getIconPath(String key) {
        return Images.getProperty(key);
    }

    public static String getIconPath(String key, String defaultKey) {
        String path = Images.getProperty(key, null);
        if (path == null) {
            path = Images.getProperty(defaultKey, null);
        }
        return path;
    }

    private static String getProperty(String key) {
        return Images.getProperty(key, null);
    }

    private static String getProperty(String key, String defaultString) {
        String str = defaultString;
        if (RESOURCE_BUNDLE.containsKey(key)) {
            str = RESOURCE_BUNDLE.getString(key);
        }
        return str;
    }
}

