/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.text.contentassist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import jp.sourceforge.f77editorplugin.text.contentassist.CompletionWord;
import jp.sourceforge.f77editorplugin.text.contentassist.ProposalBuilder;
import jp.sourceforge.f77editorplugin.text.contentassist.StatementNode;
import jp.sourceforge.f77editorplugin.text.contentassist.StatementParser;
import jp.sourceforge.f77editorplugin.text.preference.DefinitionWord;
import jp.sourceforge.f77editorplugin.text.preference.PreferenceManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.CompletionProposal;

public class CompletionProposalProvider {
    private StatementParser fParser = new StatementParser();
    private PreferenceManager fPreferecne = PreferenceManager.getInstance();
    private ProposalBuilder fProposalBuilder = new ProposalBuilder();

    public Collection<CompletionProposal> createSyntaxProposals(String qualifier, int documentOffset) {
        return this.createWordProposals(this.fPreferecne.getSyntaxWords(), qualifier, documentOffset);
    }

    public Collection<CompletionProposal> createFunctionProposals(String qualifier, int documentOffset) {
        return this.createWordProposals(this.fPreferecne.getFunctionNames(), qualifier, documentOffset);
    }

    private Collection<CompletionProposal> createWordProposals(Map<String, DefinitionWord> words, String qualifier, int documentOffset) {
        ArrayList<CompletionProposal> propList = new ArrayList<CompletionProposal>();
        if (words == null) {
            return propList;
        }
        if (qualifier.trim().equals("")) {
            return propList;
        }
        TreeSet<CompletionWord> completionWords = new TreeSet<CompletionWord>();
        for (DefinitionWord definitionWord : words.values()) {
            completionWords.add(new CompletionWord(definitionWord));
        }
        for (CompletionWord completionWord : completionWords) {
            String replaceWord = completionWord.getReplaceWord(qualifier);
            if (replaceWord == null) continue;
            CompletionProposal proposal = this.fProposalBuilder.createProposal(qualifier, documentOffset, replaceWord, completionWord.getDescription());
            propList.add(proposal);
        }
        return propList;
    }

    public Collection<CompletionProposal> createVariableProposals(IDocument doc, String qualifier, int documentOffset) throws BadLocationException {
        ArrayList<CompletionProposal> propList = new ArrayList<CompletionProposal>();
        if (qualifier.trim().equals("")) {
            return propList;
        }
        Map<String, DefinitionWord> syntaxWords = this.fPreferecne.getSyntaxWords();
        ITypedRegion[] regions = doc.getDocumentPartitioner().computePartitioning(0, doc.getLineInformationOfOffset(documentOffset).getOffset());
        TreeMap proposalWords = new TreeMap();
        for (StatementNode node : this.fParser.parse(doc, regions)) {
            DefinitionWord w;
            String key = node.getType();
            if (!syntaxWords.containsKey(key) || !(w = syntaxWords.get(key)).isDaclaration()) continue;
            CompletionWord[] completionWordArray = node.createCompetionWords();
            int n = completionWordArray.length;
            int n2 = 0;
            while (n2 < n) {
                CompletionWord propWord = completionWordArray[n2];
                String word = propWord.getReplaceWord(qualifier);
                if (word != null) {
                    if (!proposalWords.containsKey(word)) {
                        proposalWords.put(word, new TreeSet());
                    }
                    ((Set)proposalWords.get(word)).add(propWord.getDescription());
                }
                ++n2;
            }
        }
        for (String word : proposalWords.keySet()) {
            Set types = (Set)proposalWords.get(word);
            CompletionProposal proposal = this.fProposalBuilder.createProposal(qualifier, documentOffset, word, types.toArray(new String[types.size()]));
            propList.add(proposal);
        }
        return propList;
    }
}

