/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.text.contentassist;

import jp.sourceforge.f77editorplugin.text.preference.DefinitionWord;

public class CompletionWord
implements Comparable<CompletionWord> {
    private static final String SPACE = " ";
    private String fReplaceWord;
    private String fDescription;
    private String fCompareKey;

    public CompletionWord(String word, String description) {
        this.fReplaceWord = word;
        this.fDescription = description;
        this.fCompareKey = this.fReplaceWord.concat(this.fDescription);
    }

    public CompletionWord(DefinitionWord word) {
        this(word.getName(), word.getDescription().concat(SPACE).concat(word.getParams()));
    }

    public String getDescription() {
        if (this.fDescription.length() > 0) {
            return String.valueOf(this.fDescription.substring(0, 1).toUpperCase()) + this.fDescription.substring(1).replaceAll(",[ ]*", ", ").toLowerCase();
        }
        return this.fDescription;
    }

    public String getReplaceWord(String qualifier) {
        if (this.fReplaceWord.toUpperCase().startsWith(qualifier)) {
            return this.fReplaceWord.toUpperCase();
        }
        if (this.fReplaceWord.toLowerCase().startsWith(qualifier)) {
            return this.fReplaceWord.toLowerCase();
        }
        if (this.fReplaceWord.startsWith(qualifier.toUpperCase())) {
            return this.fReplaceWord;
        }
        if (this.fReplaceWord.startsWith(qualifier.toLowerCase())) {
            return this.fReplaceWord;
        }
        return null;
    }

    @Override
    public int compareTo(CompletionWord w) {
        return this.fCompareKey.compareTo(w.fCompareKey);
    }
}

