/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.text.contentassist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.f77editorplugin.text.contentassist.CompletionWord;

public class StatementNode {
    private static Pattern REGEX_ARRAY_WORD = Pattern.compile("(.+)(\\(.*\\))");
    private String fStatementLabel;
    private String fStatementType;
    private Collection<String> fVariables = new LinkedList<String>();

    public String getLabel() {
        return this.fStatementLabel;
    }

    public void setLabel(String label) {
        this.fStatementLabel = label.trim();
    }

    public String getType() {
        return this.fStatementType != null ? this.fStatementType : "";
    }

    public void setType(String type) {
        this.fStatementType = type.toUpperCase().trim();
    }

    public CompletionWord[] createCompetionWords() {
        ArrayList<CompletionWord> list = new ArrayList<CompletionWord>();
        for (String v : this.fVariables) {
            String d;
            String w;
            Matcher m = REGEX_ARRAY_WORD.matcher(v);
            if (m.matches()) {
                w = m.group(1);
                d = String.valueOf(this.fStatementType) + " " + m.group(2);
            } else {
                w = v;
                d = this.fStatementType;
            }
            list.add(new CompletionWord(w, d));
        }
        return list.toArray(new CompletionWord[list.size()]);
    }

    public void addVariable(String word) {
        this.fVariables.add(word.trim());
    }
}

