/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.text.contentassist;

import java.util.ArrayList;
import java.util.Collection;
import jp.sourceforge.f77editorplugin.text.TokenProvider;
import jp.sourceforge.f77editorplugin.text.contentassist.StatementNode;
import jp.sourceforge.f77editorplugin.text.scanners.ProposalWordScanner;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class StatementParser {
    private ProposalWordScanner fProposalWordScanner = new ProposalWordScanner();

    public Collection<StatementNode> parse(IDocument doc, ITypedRegion[] regions) throws BadLocationException {
        ArrayList<StatementNode> nodeList = new ArrayList<StatementNode>();
        int i = 0;
        while (i < regions.length) {
            ITypedRegion reg = regions[i];
            if (reg.getType().equals("__f77_statement")) {
                IToken t;
                this.fProposalWordScanner.setRange(doc, reg.getOffset(), reg.getLength());
                StatementNode node = new StatementNode();
                while ((t = this.fProposalWordScanner.nextToken()) != Token.EOF) {
                    String word;
                    if (TokenProvider.STATEMENT_WORD.equals(t)) {
                        word = doc.get(this.fProposalWordScanner.getTokenOffset(), this.fProposalWordScanner.getTokenLength());
                        node.addVariable(word);
                        continue;
                    }
                    if (TokenProvider.STATEMENT_SYNTAX_WORD.equals(t)) {
                        word = doc.get(this.fProposalWordScanner.getTokenOffset(), this.fProposalWordScanner.getTokenLength());
                        node.setType(word);
                        continue;
                    }
                    if (!TokenProvider.STATEMENT_LABEL.equals(t)) continue;
                    word = doc.get(this.fProposalWordScanner.getTokenOffset(), this.fProposalWordScanner.getTokenLength());
                    node.setLabel(word);
                }
                nodeList.add(node);
            }
            ++i;
        }
        return nodeList;
    }
}

