/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.text.preference;

import java.util.HashMap;
import java.util.Map;
import jp.sourceforge.f77editorplugin.text.Activator;
import jp.sourceforge.f77editorplugin.text.Messages;
import jp.sourceforge.f77editorplugin.text.preference.DefinitionWord;
import jp.sourceforge.f77editorplugin.text.preference.codec.WordItemCodec;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class PreferenceManager
implements IPropertyChangeListener {
    private static PreferenceManager instance;
    protected Map<String, DefinitionWord> syntaxWords = new HashMap<String, DefinitionWord>();
    protected Map<String, DefinitionWord> functionNames = new HashMap<String, DefinitionWord>();

    private PreferenceManager() {
        this.refleshSyntaxWords();
        this.refleshFunctionNames();
        PreferenceManager.getStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public static PreferenceManager getInstance() {
        if (instance == null) {
            instance = new PreferenceManager();
        }
        return instance;
    }

    public void dispose() {
        PreferenceManager.getStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.refleshSyntaxWords();
        this.refleshFunctionNames();
    }

    public static IPreferenceStore getStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    public Map<String, DefinitionWord> getSyntaxWords() {
        return this.syntaxWords;
    }

    public Map<String, DefinitionWord> getFunctionNames() {
        return this.functionNames;
    }

    private void refleshSyntaxWords() {
        this.syntaxWords.clear();
        WordItemCodec codec = new WordItemCodec(Messages.getBundle(), "Preference.Syntax.Word.Category.");
        for (String[] item : codec.decode(PreferenceManager.getStore().getString("preferenece.store.syntaxWords"))) {
            DefinitionWord w = new DefinitionWord(DefinitionWord.Type.SYNTAXWORD, item);
            this.syntaxWords.put(w.getKey(), w);
            if (!w.hasAlias()) continue;
            this.syntaxWords.put(w.getAliasKey(), w);
        }
    }

    private void refleshFunctionNames() {
        this.functionNames.clear();
        WordItemCodec codec = new WordItemCodec(Messages.getBundle(), "Preference.Syntax.Function.Category.");
        for (String[] item : codec.decode(PreferenceManager.getStore().getString("preferenece.store.syntaxFunctions"))) {
            DefinitionWord w = new DefinitionWord(DefinitionWord.Type.FUNCTION, item);
            this.functionNames.put(w.getKey(), w);
        }
    }

    public static interface Keys {
        public static final String STORE_SYNTAX_SYMBOL_LINE_COMMENT = "preferenece.store.syntax.symbol.lineComment";
        public static final String STORE_SYNTAX_SYMBOL_INLINE_COMMENT = "preferenece.store.syntax.symbol.inlineComment";
        public static final String STORE_SYNTAX_SYMBOL_QUOTE = "preferenece.store.syntax.symbol.quote";
        public static final String STORE_SYNTAX_WORDS = "preferenece.store.syntaxWords";
        public static final String STORE_SYNTAX_FUNCTIONS = "preferenece.store.syntaxFunctions";
    }
}

