/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.text.preference.ui;

import jp.sourceforge.f77editorplugin.common.ui.dialog.ITableItemDialog;
import jp.sourceforge.f77editorplugin.common.ui.preference.MapTableFieldEditor;
import jp.sourceforge.f77editorplugin.text.Messages;
import jp.sourceforge.f77editorplugin.text.preference.codec.FunctionItemCodec;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class FunctionItemEditor
extends MapTableFieldEditor {
    public FunctionItemEditor(String name, String labelText, Composite parent, int width, int height, ITableItemDialog dialogFactory) {
        super(name, labelText, parent, width, height, dialogFactory);
    }

    protected void doLoad() {
        if (this.tableField != null) {
            TableColumn col = new TableColumn(this.tableField, 0);
            col.setText(Messages.getString("Preference.Syntax.Function.NameColumn.label"));
            col.setWidth(this.widthHint / 2);
            col = new TableColumn(this.tableField, 0);
            col.setText(Messages.getString("Preference.Syntax.Function.ParameterColumn.label"));
            col.setWidth(this.widthHint / 2);
            col = new TableColumn(this.tableField, 0);
            col.setWidth(0);
            this.loadPreference(this.getPreferenceStore().getString(this.getPreferenceName()));
        }
    }

    protected void doLoadDefault() {
        this.tableField.removeAll();
        this.loadPreference(this.getPreferenceStore().getDefaultString(this.getPreferenceName()));
    }

    private void loadPreference(String preference) {
        FunctionItemCodec codec = new FunctionItemCodec(Messages.getBundle(), "Preference.Syntax.Function.Category.");
        for (String[] item : codec.decode(preference)) {
            TableItem tableItem = new TableItem(this.tableField, 0);
            tableItem.setText(item);
        }
    }

    protected void doStore() {
        FunctionItemCodec codec = new FunctionItemCodec();
        TableItem[] tableItemArray = this.tableField.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            codec.put(tableItem.getText(0), tableItem.getText(1), tableItem.getText(2));
            ++n2;
        }
        this.getPreferenceStore().setValue(this.getPreferenceName(), codec.encode());
    }
}

