/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.text.rules;

import jp.sourceforge.f77editorplugin.text.rules.AbstractRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class QuotedWordRule
extends AbstractRule {
    private static final String QUOTE_SYMBOLS = "'";
    private int resumedEscapeCount = 0;

    public QuotedWordRule(IToken successToken) {
        super(successToken);
    }

    @Override
    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        if (scanner.getColumn() < 6 || scanner.getColumn() > 72) {
            return Token.UNDEFINED;
        }
        if (resume) {
            this.searchEndForQuoteStyle(scanner);
            return this.getSuccessToken();
        }
        char c = (char)scanner.read();
        if (scanner.getColumn() > 6 && this.isQuoteSymbol(c)) {
            this.searchEndForQuoteStyle(scanner);
            return this.successToken;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    private void searchEndForQuoteStyle(ICharacterScanner scanner) {
        char c;
        int escapeCount;
        int n = escapeCount = this.isResumed ? this.resumedEscapeCount : 0;
        do {
            if (escapeCount > 0) {
                --escapeCount;
            }
            if ((c = (char)scanner.read()) == '\uffff') break;
            char next = (char)scanner.read();
            scanner.unread();
            if (escapeCount == 0 && this.isQuoteSymbol(c) && this.isQuoteSymbol(next)) {
                escapeCount = 2;
            }
            if (scanner.getColumn() <= 72) continue;
            this.isResumed = true;
            this.resumedEscapeCount = escapeCount;
            return;
        } while (escapeCount != 0 || !this.isQuoteSymbol(c));
        this.isResumed = false;
    }

    private boolean isQuoteSymbol(char c) {
        return QUOTE_SYMBOLS.indexOf(c) != -1;
    }
}

