/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.text.rules;

import jp.sourceforge.f77editorplugin.text.detectors.WhitespaceDetector;
import jp.sourceforge.f77editorplugin.text.rules.AbstractRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class WhitespaceRule
extends AbstractRule {
    private final WhitespaceDetector whitespaceDetector = new WhitespaceDetector();

    public WhitespaceRule(IToken successToken) {
        super(successToken);
    }

    @Override
    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        char c = (char)scanner.read();
        if (!this.whitespaceDetector.isWhitespace(c)) {
            scanner.unread();
            return Token.UNDEFINED;
        }
        while ((c = (char)scanner.read()) != '\uffff' && this.whitespaceDetector.isWhitespace(c)) {
        }
        scanner.unread();
        return this.getSuccessToken();
    }
}

