/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.common.ui;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ColorManager
implements ISharedTextColors {
    public static RGB RGB_DEFAULT = new RGB(0, 0, 0);
    protected static ColorManager instance;
    protected Map<RGB, Color> colorTable = Collections.synchronizedMap(new HashMap());

    public static ColorManager getInstance() {
        if (instance == null) {
            instance = new ColorManager();
        }
        return instance;
    }

    public void dispose() {
        Iterator<Color> e = this.colorTable.values().iterator();
        while (e.hasNext()) {
            e.next().dispose();
        }
    }

    public Color getColor(RGB rgb) {
        if (!this.colorTable.containsKey(rgb)) {
            this.colorTable.put(rgb, new Color((Device)Display.getCurrent(), rgb));
        }
        return this.colorTable.get(rgb);
    }

    public Color getSystemColor(int id) {
        return Display.getCurrent().getSystemColor(id);
    }

    public static String convertToString(RGB rgb) {
        return String.valueOf(String.valueOf(rgb.red)) + ',' + String.valueOf(rgb.green) + ',' + String.valueOf(rgb.blue);
    }
}

