/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.common.ui.preference;

import java.util.Map;
import jp.sourceforge.f77editorplugin.common.ui.dialog.AbstractTableItemDialog;
import jp.sourceforge.f77editorplugin.common.ui.dialog.ITableItemDialog;
import jp.sourceforge.f77editorplugin.core.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public abstract class MapTableFieldEditor
extends FieldEditor {
    protected Table tableField;
    protected Composite controlPanel;
    protected Button addButton;
    protected Button editButton;
    protected Button removeButton;
    protected int widthHint = -1;
    protected int heightHint = -1;
    protected Map<String, String> typeNameMap;
    protected ITableItemDialog dialogFactory;

    public MapTableFieldEditor(String name, String labelText, Composite parent, int width, int height, ITableItemDialog dialogFactory) {
        this.widthHint = width;
        this.heightHint = height;
        this.dialogFactory = dialogFactory;
        this.init(name, labelText);
        this.createControl(parent);
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getTableField(parent);
        Composite panel = this.getControlPanel(parent);
        if (this.dialogFactory != null) {
            this.getAddButton(panel);
            this.getEditButton(panel);
            this.getRemoveButton(panel);
        }
    }

    protected void adjustForNumColumns(int numColumns) {
    }

    public int getNumberOfControls() {
        return 2;
    }

    protected Table getTableField(final Composite parent) {
        if (this.tableField == null) {
            this.tableField = new Table(parent, 68354);
            this.tableField.setHeaderVisible(true);
            this.tableField.setLinesVisible(true);
            this.tableField.setLayoutData((Object)this.createTableGridData(1040));
            this.tableField.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MapTableFieldEditor.this.getRemoveButton(parent).setEnabled(MapTableFieldEditor.this.tableField.getSelectionCount() > 0);
                    MapTableFieldEditor.this.getEditButton(parent).setEnabled(MapTableFieldEditor.this.tableField.getSelectionCount() > 0);
                }
            });
        }
        return this.tableField;
    }

    protected Composite getControlPanel(Composite parent) {
        if (this.controlPanel == null) {
            this.controlPanel = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.controlPanel.setLayout((Layout)layout);
            this.controlPanel.setLayoutData((Object)new GridData(1808));
        }
        return this.controlPanel;
    }

    protected Button getAddButton(final Composite parent) {
        if (this.addButton == null) {
            this.addButton = new Button(parent, 8);
            this.addButton.setText(Messages.getString("MapTableFieldEditor.label.add"));
            this.addButton.setLayoutData((Object)this.createButtonGridData());
            this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractTableItemDialog dialog = (AbstractTableItemDialog)MapTableFieldEditor.this.dialogFactory.CreateInstance();
                    if (dialog.open() == 0 && dialog.Validate()) {
                        TableItem item = new TableItem(MapTableFieldEditor.this.tableField, 0);
                        item.setText(dialog.getValuesForTableItem());
                        MapTableFieldEditor.this.tableField.setSelection(MapTableFieldEditor.this.tableField.getItemCount() - 1);
                    }
                    MapTableFieldEditor.this.getRemoveButton(parent).setEnabled(MapTableFieldEditor.this.tableField.getSelectionCount() > 0);
                    MapTableFieldEditor.this.getEditButton(parent).setEnabled(MapTableFieldEditor.this.tableField.getSelectionCount() > 0);
                }
            });
        }
        return this.addButton;
    }

    protected Button getEditButton(final Composite parent) {
        if (this.editButton == null) {
            this.editButton = new Button(parent, 8);
            this.editButton.setEnabled(false);
            this.editButton.setText(Messages.getString("MapTableFieldEditor.label.edit"));
            this.editButton.setLayoutData((Object)this.createButtonGridData());
            this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractTableItemDialog dialog = (AbstractTableItemDialog)MapTableFieldEditor.this.dialogFactory.CreateInstance();
                    TableItem selected = MapTableFieldEditor.this.tableField.getItem(MapTableFieldEditor.this.tableField.getSelectionIndex());
                    dialog.setKey(selected.getText(0));
                    dialog.setDescription(selected.getText(1));
                    dialog.setValue(selected.getText(2));
                    if (dialog.open() == 0 && dialog.Validate()) {
                        selected.setText(dialog.getValuesForTableItem());
                    }
                    MapTableFieldEditor.this.getRemoveButton(parent).setEnabled(MapTableFieldEditor.this.tableField.getSelectionCount() > 0);
                    MapTableFieldEditor.this.getEditButton(parent).setEnabled(MapTableFieldEditor.this.tableField.getSelectionCount() > 0);
                }
            });
        }
        return this.editButton;
    }

    protected Button getRemoveButton(final Composite parent) {
        if (this.removeButton == null) {
            this.removeButton = new Button(parent, 8);
            this.removeButton.setEnabled(false);
            this.removeButton.setText(Messages.getString("MapTableFieldEditor.lebel.delete"));
            this.removeButton.setLayoutData((Object)this.createButtonGridData());
            this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableItem selected = MapTableFieldEditor.this.tableField.getItem(MapTableFieldEditor.this.tableField.getSelectionIndex());
                    String title = Messages.getString("MapTableFieldEditor.title.confirmDelete");
                    String mes = String.format(Messages.getString("MapTableFieldEditor.message.confirmDelete"), selected.getText(0));
                    if (MessageDialog.openQuestion((Shell)parent.getShell(), (String)title, (String)mes)) {
                        MapTableFieldEditor.this.tableField.remove(MapTableFieldEditor.this.tableField.getSelectionIndex());
                    }
                    MapTableFieldEditor.this.getRemoveButton(parent).setEnabled(MapTableFieldEditor.this.tableField.getSelectionCount() > 0);
                    MapTableFieldEditor.this.getEditButton(parent).setEnabled(MapTableFieldEditor.this.tableField.getSelectionCount() > 0);
                }
            });
        }
        return this.removeButton;
    }

    protected GridData createTableGridData(int style) {
        GridData grid = new GridData(style);
        if (this.heightHint > 0) {
            grid.heightHint = this.heightHint;
        }
        if (this.widthHint > 0) {
            grid.widthHint = this.widthHint;
        }
        return grid;
    }

    private GridData createButtonGridData() {
        GridData grid = new GridData();
        grid.widthHint = 120;
        grid.verticalAlignment = 128;
        return grid;
    }
}

