/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.core.internal.preference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.TreeSet;
import jp.sourceforge.f77editorplugin.core.internal.preference.IPreferenceCodec;

public abstract class PreferenceCodec
implements IPreferenceCodec {
    protected Map<String, Collection<String>> fBuffer = new TreeMap<String, Collection<String>>();
    protected ResourceBundle fResourceBundle;
    private String fPrefix;

    public PreferenceCodec() {
    }

    public PreferenceCodec(ResourceBundle messageResource) {
        this();
        this.fResourceBundle = messageResource;
    }

    public PreferenceCodec(ResourceBundle messageResource, String prefix) {
        this(messageResource);
        this.fPrefix = prefix;
    }

    @Override
    public void setPrefix(String prefix) {
        this.fPrefix = prefix;
    }

    @Override
    public void put(String key, String value) {
        if (!this.fBuffer.containsKey(key)) {
            this.fBuffer.put(key, new TreeSet());
        }
        this.fBuffer.get(key).add(value);
    }

    @Override
    public String localize(String string) {
        String localized;
        try {
            localized = this.fResourceBundle.getString(String.valueOf(this.fPrefix) + string);
        }
        catch (MissingResourceException missingResourceException) {
            localized = string;
        }
        return localized;
    }

    @Override
    public String encode() {
        StringBuffer buf = new StringBuffer();
        for (String key : this.fBuffer.keySet()) {
            for (String value : this.fBuffer.get(key)) {
                buf.append(key);
                buf.append("|");
                buf.append(value);
                buf.append(";");
            }
        }
        return buf.toString();
    }

    @Override
    public Collection<String[]> decode(String data) {
        String[] items;
        ArrayList<String[]> list = new ArrayList<String[]>();
        String[] stringArray = items = data.split("[;]{1}");
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String itemString = stringArray[n2];
            String[] item = this.createItem(itemString.split("[|]{1}", 2));
            if (item != null) {
                list.add(item);
            }
            ++n2;
        }
        return list;
    }

    public String[] decodeFirst(String data) {
        String[] items = data.split("[;]{1}");
        if (items.length > 0) {
            return this.createItem(items[0].split("[|]{1}", 2));
        }
        return new String[3];
    }

    protected abstract String[] createItem(String[] var1);
}

