/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.editor.contentassist;

import java.util.ArrayList;
import jp.sourceforge.f77editorplugin.text.Messages;
import jp.sourceforge.f77editorplugin.text.contentassist.CompletionProposalProvider;
import jp.sourceforge.f77editorplugin.text.detectors.FortranWordDetector;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextOperationAction;

public class ContentAssistProcessor
implements IContentAssistProcessor {
    public static final String ACTION_ID = "jp.sourceforge.f77editorplugin.editor.ContentAssistProcessor";
    private CompletionProposalProvider proposalProvider = new CompletionProposalProvider();
    private IWordDetector wordDetector = new FortranWordDetector();
    private boolean fEnableVariableProposals = false;
    private boolean fEnableSyntaxProposals = false;
    private boolean fEnableFunctionProposals = false;

    public void enableVariableProposals(boolean enable) {
        this.fEnableVariableProposals = enable;
    }

    public void enableSyntaxProposals(boolean enable) {
        this.fEnableSyntaxProposals = enable;
    }

    public void enableFunctionProposals(boolean enable) {
        this.fEnableFunctionProposals = enable;
    }

    public static IAction createAction(ITextEditor editor) {
        TextOperationAction action = new TextOperationAction(Messages.getBundle(), "ContentAssistProposal", editor, 13);
        action.setActionDefinitionId(ACTION_ID);
        return action;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        IDocument doc = viewer.getDocument();
        ArrayList propList = new ArrayList();
        String qualifier = this.getQualifier(doc, offset);
        try {
            if (this.fEnableVariableProposals) {
                propList.addAll(this.proposalProvider.createVariableProposals(doc, qualifier, offset));
            }
            if (this.fEnableSyntaxProposals) {
                propList.addAll(this.proposalProvider.createSyntaxProposals(qualifier, offset));
            }
            if (this.fEnableFunctionProposals) {
                propList.addAll(this.proposalProvider.createFunctionProposals(qualifier, offset));
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return propList.toArray(new ICompletionProposal[propList.size()]);
    }

    protected String getQualifier(IDocument doc, int documentOffset) {
        StringBuffer buf = new StringBuffer();
        try {
            while (true) {
                char c;
                if (!this.wordDetector.isWordPart(c = doc.getChar(--documentOffset))) {
                    return buf.reverse().toString();
                }
                buf.append(c);
            }
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz.".toCharArray();
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }
}

