/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.editor.internal;

import jp.sourceforge.f77editorplugin.common.ui.ColorManager;
import jp.sourceforge.f77editorplugin.editor.contentassist.ContentAssistProcessor;
import jp.sourceforge.f77editorplugin.editor.preference.PreferenceManager;
import jp.sourceforge.f77editorplugin.editor.scanner.CommentPresentationScanner;
import jp.sourceforge.f77editorplugin.editor.scanner.DefaultPresentationScanner;
import jp.sourceforge.f77editorplugin.editor.scanner.StatementPresentationScanner;
import jp.sourceforge.f77editorplugin.editor.sterategy.DoubleClickStrategy;
import jp.sourceforge.f77editorplugin.editor.sterategy.ProjectionReconcilingStrategy;
import jp.sourceforge.f77editorplugin.editor.ui.FortranEditor;
import jp.sourceforge.f77editorplugin.text.repairers.StatementDamagerRepairer;
import jp.sourceforge.f77editorplugin.text.scanners.PartitionScanner;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class Configuration
extends SourceViewerConfiguration
implements IPropertyChangeListener {
    private DoubleClickStrategy doubleClickStrategy;
    private ColorManager colorManager = ColorManager.getInstance();
    private PresentationReconciler presentationReconciler;
    private FortranEditor editor;
    private DefaultPresentationScanner defaultTokenScanner;
    private CommentPresentationScanner commentTokenScanner;
    private StatementPresentationScanner statementTokenScanner;
    private IReconciler reconciler;

    public Configuration(FortranEditor editor) {
        this.editor = editor;
        PreferenceManager.getStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void dispose() {
        PreferenceManager.getStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return PartitionScanner.getContentTypes();
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.doubleClickStrategy == null) {
            this.doubleClickStrategy = new DoubleClickStrategy();
        }
        return this.doubleClickStrategy;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        if (this.presentationReconciler == null) {
            this.presentationReconciler = new PresentationReconciler();
            DefaultDamagerRepairer commentDamagerRepairer = new DefaultDamagerRepairer((ITokenScanner)this.getCommentTokenScanner());
            this.presentationReconciler.setDamager((IPresentationDamager)commentDamagerRepairer, "__f77_comment");
            this.presentationReconciler.setRepairer((IPresentationRepairer)commentDamagerRepairer, "__f77_comment");
            StatementDamagerRepairer statementDamagerRepaire = new StatementDamagerRepairer((ITokenScanner)this.getSyntaxTokenScanner());
            this.presentationReconciler.setDamager((IPresentationDamager)statementDamagerRepaire, "__f77_statement");
            this.presentationReconciler.setRepairer((IPresentationRepairer)statementDamagerRepaire, "__f77_statement");
            DefaultDamagerRepairer defaultDamagerRepairer = new DefaultDamagerRepairer((ITokenScanner)this.getDefaultTokenScanner());
            this.presentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer, "__dftl_partition_content_type");
            this.presentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer, "__dftl_partition_content_type");
        }
        return this.presentationReconciler;
    }

    private DefaultPresentationScanner getDefaultTokenScanner() {
        if (this.defaultTokenScanner == null) {
            this.defaultTokenScanner = new DefaultPresentationScanner(this.colorManager);
        }
        return this.defaultTokenScanner;
    }

    private CommentPresentationScanner getCommentTokenScanner() {
        if (this.commentTokenScanner == null) {
            this.commentTokenScanner = new CommentPresentationScanner(this.colorManager);
        }
        return this.commentTokenScanner;
    }

    protected StatementPresentationScanner getSyntaxTokenScanner() {
        if (this.statementTokenScanner == null) {
            this.statementTokenScanner = new StatementPresentationScanner(this.colorManager);
        }
        return this.statementTokenScanner;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        if (this.reconciler == null) {
            ProjectionReconcilingStrategy strategy = new ProjectionReconcilingStrategy(this.editor.getProjectionProcessor());
            this.reconciler = new MonoReconciler((IReconcilingStrategy)strategy, false);
        }
        return this.reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistProcessor processor = new ContentAssistProcessor();
        processor.enableVariableProposals(PreferenceManager.getStore().getBoolean("editor.contentAssist.variableNameProposal"));
        processor.enableSyntaxProposals(PreferenceManager.getStore().getBoolean("editor.contentAssist.syntaxWordProposal"));
        processor.enableFunctionProposals(PreferenceManager.getStore().getBoolean("editor.contentAssist.functionNameProposal"));
        ContentAssistant assistant = new ContentAssistant();
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__f77_statement");
        assistant.enableAutoActivation(PreferenceManager.getStore().getBoolean("editor.contentAssist.autoActivation.enable"));
        assistant.setAutoActivationDelay(PreferenceManager.getStore().getInt("editor.contentAssist.autoActivation.delay"));
        assistant.install((ITextViewer)sourceViewer);
        return assistant;
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.getSyntaxTokenScanner().setRules();
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        return null;
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        int indentWidth;
        StringBuffer buf = new StringBuffer();
        try {
            indentWidth = Integer.parseInt(PreferenceManager.getString("editor.indentWidth"));
        }
        catch (NumberFormatException numberFormatException) {
            indentWidth = 2;
        }
        int i = 0;
        while (i < indentWidth) {
            buf.append(" ");
            ++i;
        }
        return new String[]{buf.toString(), "\t", "  ", " ", ""};
    }
}

