/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.editor.preference;

import java.util.Properties;
import jp.sourceforge.f77editorplugin.editor.preference.PreferenceManager;
import jp.sourceforge.f77editorplugin.editor.preference.PreferenceProperty;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;

public class PreferenceInitializer
extends AbstractPreferenceInitializer {
    private Properties properties;

    public void initializeDefaultPreferences() {
        this.properties = PreferenceProperty.getProperties();
        IPreferenceStore store = PreferenceManager.getStore();
        this.initializeEditorViewPreferences(store);
        this.initializeColorPreferences(store);
        this.initializeRevisionCommentPreferences(store);
        this.initializeContentAssistPreferences(store);
    }

    private void initializeColorPreferences(IPreferenceStore store) {
        this.setDefalutValue(store, "editor.color.background");
        this.setDefalutValue(store, "editor.color.statementText");
        this.setDefalutValue(store, "editor.color.commentText");
        this.setDefalutValue(store, "editor.color.syntaxWord");
        this.setDefalutValue(store, "editor.color.functionName");
        this.setDefalutValue(store, "editor.color.characterConstant");
        this.setDefalutValue(store, "editor.color.continueSymbol");
        this.setDefalutValue(store, "editor.color.statementLabel");
        this.setDefalutValue(store, "editor.color.ignoreText");
        this.setDefalutValue(store, "editor.color.columnLine");
    }

    private void initializeRevisionCommentPreferences(IPreferenceStore store) {
        this.setDefalutValue(store, "editor.revisionComment.modifyHeader");
        this.setDefalutValue(store, "editor.revisionComment.modifyFooter");
        this.setDefalutValue(store, "editor.revisionComment.addHeader");
        this.setDefalutValue(store, "editor.revisionComment.addFooter");
        this.setDefalutValue(store, "editor.revisionComment.removeHeader");
        this.setDefalutValue(store, "editor.revisionComment.removeFooter");
        this.setDefalutValue(store, "editor.revisionComment.dateFormat");
    }

    private void initializeEditorViewPreferences(IPreferenceStore store) {
        this.setDefalutValue(store, "editor.enableCommentFolding");
        this.setDefalutValue(store, "editor.indentWidth");
        this.setDefalutValue(store, "editor.linedColumns");
    }

    private void initializeContentAssistPreferences(IPreferenceStore store) {
        this.setDefalutValue(store, "editor.contentAssist.variableNameProposal");
        this.setDefalutValue(store, "editor.contentAssist.functionNameProposal");
        this.setDefalutValue(store, "editor.contentAssist.syntaxWordProposal");
        this.setDefalutValue(store, "editor.contentAssist.autoActivation.enable");
        this.setDefalutValue(store, "editor.contentAssist.autoActivation.delay");
    }

    private void setDefalutValue(IPreferenceStore store, String key) {
        store.setDefault(key, this.properties.getProperty(key));
    }
}

