/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.editor.processors;

import jp.sourceforge.f77editorplugin.editor.preference.PreferenceManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewerExtension7;
import org.eclipse.jface.text.TabsToSpacesConverter;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class TabIndentProcessor
extends TabsToSpacesConverter
implements IPropertyChangeListener {
    private int fTabRatio;
    private ILineTracker fLineTracker;

    public TabIndentProcessor(ISourceViewer viewer) {
        this.setLineTracker((ILineTracker)new DefaultLineTracker());
        this.setNumberOfSpacesPerTab();
        if (viewer instanceof ITextViewerExtension7) {
            ((ITextViewerExtension7)viewer).setTabsToSpacesConverter((IAutoEditStrategy)this);
        }
        PreferenceManager.getStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void dispose() {
        PreferenceManager.getStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.setNumberOfSpacesPerTab();
    }

    public void setNumberOfSpacesPerTab() {
        try {
            this.fTabRatio = Integer.parseInt(PreferenceManager.getString("editor.indentWidth"));
        }
        catch (NumberFormatException numberFormatException) {
            this.fTabRatio = 2;
        }
    }

    public void setLineTracker(ILineTracker lineTracker) {
        this.fLineTracker = lineTracker;
    }

    protected int insertTabString(StringBuffer buffer, int offsetInLine) {
        if (this.fTabRatio == 0) {
            return 0;
        }
        int remainder = 0;
        if (offsetInLine < 1) {
            remainder = 1 - offsetInLine;
        } else if (offsetInLine < 6) {
            remainder = 6 - offsetInLine;
        } else {
            remainder = offsetInLine % this.fTabRatio;
            remainder = this.fTabRatio - remainder;
        }
        int i = 0;
        while (i < remainder) {
            buffer.append(' ');
            ++i;
        }
        return remainder;
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        String text = command.text;
        if (text == null) {
            return;
        }
        int index = text.indexOf(9);
        if (index > -1) {
            StringBuffer buffer = new StringBuffer();
            this.fLineTracker.set(command.text);
            int lines = this.fLineTracker.getNumberOfLines();
            try {
                int i = 0;
                while (i < lines) {
                    int offset = this.fLineTracker.getLineOffset(i);
                    int endOffset = offset + this.fLineTracker.getLineLength(i);
                    String line = text.substring(offset, endOffset);
                    int position = 0;
                    if (i == 0) {
                        IRegion firstLine = document.getLineInformationOfOffset(command.offset);
                        position = command.offset - firstLine.getOffset();
                    }
                    int length = line.length();
                    int j = 0;
                    while (j < length) {
                        char c = line.charAt(j);
                        if (c == '\t') {
                            position += this.insertTabString(buffer, position);
                        } else {
                            buffer.append(c);
                            ++position;
                        }
                        ++j;
                    }
                    ++i;
                }
                command.text = buffer.toString();
            }
            catch (BadLocationException badLocationException) {}
        }
    }
}

