/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.editor.scanner;

import java.util.ArrayList;
import jp.sourceforge.f77editorplugin.common.ui.ColorManager;
import jp.sourceforge.f77editorplugin.editor.internal.ColoredTokenProvider;
import jp.sourceforge.f77editorplugin.text.rules.AbstractRule;
import jp.sourceforge.f77editorplugin.text.rules.ContinueSymbolRule;
import jp.sourceforge.f77editorplugin.text.rules.FunctionNameRule;
import jp.sourceforge.f77editorplugin.text.rules.HollerithConstantRule;
import jp.sourceforge.f77editorplugin.text.rules.InlineCommentRule;
import jp.sourceforge.f77editorplugin.text.rules.OutOfBoundsRule;
import jp.sourceforge.f77editorplugin.text.rules.QuotedWordRule;
import jp.sourceforge.f77editorplugin.text.rules.StatementLabelRule;
import jp.sourceforge.f77editorplugin.text.rules.SyntaxWordRule;
import jp.sourceforge.f77editorplugin.text.rules.WhitespaceRule;
import jp.sourceforge.f77editorplugin.text.scanners.ExtendRuleBasedScanner;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class StatementPresentationScanner
extends ExtendRuleBasedScanner {
    private ColoredTokenProvider tokenProvider;

    public StatementPresentationScanner(ColorManager colorManager) {
        this.tokenProvider = new ColoredTokenProvider(colorManager);
        this.setRules();
    }

    public void setRules() {
        ArrayList<Object> ruleList = new ArrayList<Object>();
        ruleList.add(new WhitespaceRule(Token.UNDEFINED));
        IToken commentToken = this.tokenProvider.getForeColorStyledToken("editor.color.commentText", 2);
        ruleList.add(new InlineCommentRule(commentToken));
        IToken labelToken = this.tokenProvider.getForeColorToken("editor.color.statementLabel");
        ruleList.add(new StatementLabelRule(labelToken));
        IToken continueToken = this.tokenProvider.getForeColorToken("editor.color.continueSymbol");
        ruleList.add(new ContinueSymbolRule(continueToken));
        IToken characterToken = this.tokenProvider.getForeColorToken("editor.color.characterConstant");
        ruleList.add(new QuotedWordRule(characterToken));
        ruleList.add(new HollerithConstantRule(characterToken));
        IToken syntaxToken = this.tokenProvider.getForeColorToken("editor.color.syntaxWord");
        ruleList.add(new SyntaxWordRule(syntaxToken));
        IToken functionToken = this.tokenProvider.getForeColorToken("editor.color.functionName");
        ruleList.add(new FunctionNameRule(functionToken));
        IToken obToken = this.tokenProvider.getForeColorToken("editor.color.ignoreText");
        ruleList.add(new OutOfBoundsRule(obToken));
        this.setRules(ruleList.toArray(new IRule[ruleList.size()]));
    }

    public void setRange(IDocument document, int offset, int length) {
        super.setRange(document, offset, length);
        int i = 0;
        while (i < this.fRules.length) {
            if (this.fRules[i] instanceof AbstractRule) {
                ((AbstractRule)this.fRules[i]).initialize();
            }
            ++i;
        }
    }
}

