/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.editor.sterategy;

import java.util.ArrayList;
import java.util.Collection;
import jp.sourceforge.f77editorplugin.editor.preference.PreferenceManager;
import jp.sourceforge.f77editorplugin.editor.processors.ProjectionProcessor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;

public class ProjectionReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension,
IPropertyChangeListener {
    private ProjectionProcessor projectionProcessor;
    private IDocument document;
    protected boolean isProjectionCollapse = PreferenceManager.getStore().getBoolean("editor.indentWidth");
    protected final ArrayList<ITypedRegion> projectionRegions = new ArrayList();

    public ProjectionReconcilingStrategy(ProjectionProcessor projectionProcessor) {
        this.projectionProcessor = projectionProcessor;
        PreferenceManager.getStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void toggleProjectionCollapse() {
        this.isProjectionCollapse = !this.isProjectionCollapse;
    }

    public void setProjectionCollapse(boolean collapse) {
        this.isProjectionCollapse = collapse;
    }

    public void setDocument(IDocument document) {
        this.document = document;
    }

    public void initialReconcile() {
        this.projectionRegions.clear();
        this.reconcile(0, this.document.getLength());
        this.isProjectionCollapse = false;
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.projectionRegions.clear();
        this.reconcile(0, this.document.getLength());
    }

    public void reconcile(IRegion partition) {
        this.projectionRegions.clear();
        this.reconcile(0, this.document.getLength());
    }

    protected void reconcile(int offset, int length) {
        try {
            this.projectionRegions.addAll(this.computeProjectionRegions(offset, length));
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ProjectionReconcilingStrategy.this.projectionProcessor.updateProjectionAnnotations(ProjectionReconcilingStrategy.this.projectionRegions, ProjectionReconcilingStrategy.this.isProjectionCollapse);
            }
        });
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }

    protected Collection<ITypedRegion> computeProjectionRegions(int offset, int length) throws BadLocationException {
        ArrayList<ITypedRegion> list = new ArrayList<ITypedRegion>();
        ITypedRegion[] regions = this.document.computePartitioning(offset, length);
        int i = 0;
        while (i < regions.length) {
            if (this.isFoldableCommnetRegion(regions[i])) {
                list.add(regions[i]);
            }
            ++i;
        }
        return list;
    }

    protected boolean isFoldableCommnetRegion(ITypedRegion region) throws BadLocationException {
        if (!PreferenceManager.getStore().getBoolean("editor.enableCommentFolding")) {
            return false;
        }
        if (!region.getType().equals("__f77_comment")) {
            return false;
        }
        int start = this.document.getLineOfOffset(region.getOffset());
        int end = this.document.getLineOfOffset(region.getOffset() + region.getLength() - 1);
        return end - start > 0;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty() == "editor.enableCommentFolding") {
            this.initialReconcile();
        }
    }
}

