/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.editor.ui;

import jp.sourceforge.f77editorplugin.editor.contentassist.ContentAssistProcessor;
import jp.sourceforge.f77editorplugin.editor.internal.Configuration;
import jp.sourceforge.f77editorplugin.editor.internal.DocumentProvider;
import jp.sourceforge.f77editorplugin.editor.preference.PreferenceManager;
import jp.sourceforge.f77editorplugin.editor.presentation.ColumnLinePresentation;
import jp.sourceforge.f77editorplugin.editor.presentation.HighlightPresentation;
import jp.sourceforge.f77editorplugin.editor.presentation.RulerPresentation;
import jp.sourceforge.f77editorplugin.editor.presentation.SourceViewerPresentation;
import jp.sourceforge.f77editorplugin.editor.processors.ProjectionProcessor;
import jp.sourceforge.f77editorplugin.editor.processors.TabIndentProcessor;
import jp.sourceforge.f77editorplugin.editor.ui.FortranSourceViewer;
import jp.sourceforge.f77editorplugin.outline.ui.OutlinePage;
import jp.sourceforge.f77editorplugin.text.scanners.PartitionScanner;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension2;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class FortranEditor
extends AbstractDecoratedTextEditor
implements IPropertyChangeListener {
    public static final String EDITOR_ID = "#F77Editor";
    public static final String EDITOR_CONTEXT_ID = "#F77Editor.EditorContext";
    private OutlinePage outlinePage;
    private ColumnLinePresentation columnLinePresentation;
    private SourceViewerPresentation sourceViewerPresentation;
    private RulerPresentation rulerPresentation;
    private HighlightPresentation highlightPresentation;
    private ProjectionProcessor projectionProcessor;
    private TabIndentProcessor indentProcessor;

    public FortranEditor() {
        this.setSourceViewerConfiguration(new Configuration(this));
        this.setDocumentProvider((IDocumentProvider)new DocumentProvider());
        PreferenceManager.getStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void dispose() {
        super.dispose();
        this.columnLinePresentation.dispose();
        this.sourceViewerPresentation.dispose();
        this.rulerPresentation.dispose();
        this.indentProcessor.dispose();
        PreferenceManager.getStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public IVerticalRulerColumn createLineNumberRulerColumn() {
        IVerticalRulerColumn rulerColumn = super.createLineNumberRulerColumn();
        this.rulerPresentation = new RulerPresentation(rulerColumn);
        return rulerColumn;
    }

    public Object getAdapter(Class required) {
        if (IContentOutlinePage.class.equals((Object)required)) {
            return this.getOutlinePage();
        }
        return super.getAdapter(required);
    }

    private ContentOutlinePage getOutlinePage() {
        if (this.outlinePage == null) {
            this.outlinePage = new OutlinePage(this.getDocumentProvider(), (ITextEditor)this);
            if (this.getEditorInput() != null) {
                this.outlinePage.setInput((Object)this.getEditorInput());
            }
        }
        return this.outlinePage;
    }

    public void doRevertToSaved() {
        super.doRevertToSaved();
        if (this.outlinePage != null) {
            this.outlinePage.update();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        if (this.outlinePage != null) {
            this.outlinePage.update();
        }
    }

    public void doSaveAs() {
        super.doSaveAs();
        if (this.outlinePage != null) {
            this.outlinePage.update();
        }
    }

    public void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        if (this.outlinePage != null) {
            this.outlinePage.setInput((Object)input);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        ISourceViewer viewer;
        IDocument doc = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        if (doc != null) {
            FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new PartitionScanner(), PartitionScanner.getContentTypes());
            partitioner.connect(doc);
            doc.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        }
        if (!((viewer = this.getSourceViewer()) instanceof ISourceViewerExtension2)) {
            return;
        }
        ((ISourceViewerExtension2)viewer).unconfigure();
        viewer.configure(this.getSourceViewerConfiguration());
    }

    protected void handleCursorPositionChanged() {
        super.handleCursorPositionChanged();
        this.highlightPresentation.handleCursorPositionChanged();
    }

    public int getCaretOffset() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        return FortranEditor.widgetOffset2ModelOffset((ISourceViewer)sourceViewer, (int)sourceViewer.getTextWidget().getCaretOffset());
    }

    public IDocument getDocument() {
        return this.getDocumentProvider().getDocument((Object)this.getEditorInput());
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{EDITOR_CONTEXT_ID});
    }

    protected void createActions() {
        super.createActions();
        this.setAction("jp.sourceforge.f77editorplugin.editor.ContentAssistProcessor", ContentAssistProcessor.createAction((ITextEditor)this));
        this.setActionActivationCode("jp.sourceforge.f77editorplugin.editor.ContentAssistProcessor", ' ', -1, 262144);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        this.columnLinePresentation = new ColumnLinePresentation((ISourceViewer)viewer);
        this.sourceViewerPresentation = new SourceViewerPresentation((SourceViewer)viewer);
        this.highlightPresentation = new HighlightPresentation(this);
        this.projectionProcessor.installProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors());
        this.projectionProcessor.setReconciler(this.getSourceViewerConfiguration().getReconciler((ISourceViewer)viewer));
        this.projectionProcessor.setAnnotationModel((AnnotationModel)viewer.getProjectionAnnotationModel());
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        FortranSourceViewer viewer = new FortranSourceViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.indentProcessor = new TabIndentProcessor((ISourceViewer)viewer);
        this.projectionProcessor = new ProjectionProcessor();
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    public ProjectionProcessor getProjectionProcessor() {
        return this.projectionProcessor;
    }
}

