/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.editor.ui;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.widgets.Composite;

public class FortranSourceViewer
extends ProjectionViewer {
    public static final int SHIFT_OFFSET = 6;

    public FortranSourceViewer(Composite parent, IVerticalRuler ruler, IOverviewRuler overviewRuler, boolean showsAnnotationOverview, int styles) {
        super(parent, ruler, overviewRuler, showsAnnotationOverview, styles);
    }

    public void setDocument(IDocument document, IAnnotationModel annotationModel, int modelRangeOffset, int modelRangeLength) {
        super.setDocument(document, annotationModel, modelRangeOffset, modelRangeLength);
    }

    public void doOperation(int operation) {
        switch (operation) {
            case 8: {
                this.shift(true, true, true);
                break;
            }
            case 9: {
                this.shift(true, false, true);
                break;
            }
            default: {
                super.doOperation(operation);
            }
        }
    }

    protected void shift(boolean useDefaultPrefixes, boolean right, boolean ignoreWhitespace) {
        block23: {
            if (this.fUndoManager != null) {
                this.fUndoManager.beginCompoundChange();
            }
            IDocument d = this.getDocument();
            DocumentRewriteSession rewriteSession = null;
            try {
                try {
                    ITextSelection selection = (ITextSelection)this.getSelection();
                    if (d instanceof IDocumentExtension4) {
                        IDocumentExtension4 extension = (IDocumentExtension4)d;
                        rewriteSession = extension.startRewriteSession(DocumentRewriteSessionType.SEQUENTIAL);
                    }
                    int start = selection.getStartLine();
                    int end = selection.getEndLine();
                    if (right) {
                        int l = start;
                        while (l <= end) {
                            int offset = d.getLineOffset(l);
                            int length = d.getLineLength(l);
                            ITypedRegion[] regions = TextUtilities.computePartitioning((IDocument)d, (String)this.getDocumentPartitioning(), (int)offset, (int)length, (boolean)false);
                            String contentType = regions[0].getType();
                            String[] prefixes = (String[])this.fIndentChars.get(contentType);
                            String text = d.get(offset, length);
                            if (ignoreWhitespace) {
                                text = text.replaceAll("[\\s]*$", "");
                            }
                            if (contentType == "__f77_statement" && text.length() > 6) {
                                d.replace(d.getLineOffset(l) + 6, 0, prefixes[0]);
                            }
                            if (contentType == "__f77_comment" && text.length() > 6 && text.substring(1, 6).trim().length() == 0) {
                                d.replace(d.getLineOffset(l) + 6, 0, prefixes[0]);
                            }
                            ++l;
                        }
                    } else {
                        int l = start;
                        while (l <= end) {
                            int offset = d.getLineOffset(l);
                            int length = d.getLineLength(l);
                            ITypedRegion[] regions = TextUtilities.computePartitioning((IDocument)d, (String)this.getDocumentPartitioning(), (int)offset, (int)length, (boolean)false);
                            String contentType = regions[0].getType();
                            String[] prefixes = (String[])this.fIndentChars.get(contentType);
                            if (prefixes != null) {
                                String prefix;
                                String text = d.get(offset, length);
                                int[] found = TextUtilities.indexOf((String[])prefixes, (String)text, (int)6);
                                if (contentType == "__f77_statement" && found[0] == 6) {
                                    prefix = prefixes[found[1]];
                                    d.replace(offset + found[0], prefix.length(), "");
                                }
                                if (contentType == "__f77_comment" && text.length() > 6 && text.substring(1, 6).trim().length() == 0 && found[0] == 6) {
                                    prefix = prefixes[found[1]];
                                    d.replace(offset + found[0], prefix.length(), "");
                                }
                            }
                            ++l;
                        }
                    }
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                    if (d instanceof IDocumentExtension4) {
                        IDocumentExtension4 extension = (IDocumentExtension4)d;
                        extension.stopRewriteSession(rewriteSession);
                    }
                    if (this.fUndoManager != null) {
                        this.fUndoManager.endCompoundChange();
                    }
                    break block23;
                }
            }
            catch (Throwable throwable) {
                if (d instanceof IDocumentExtension4) {
                    IDocumentExtension4 extension = (IDocumentExtension4)d;
                    extension.stopRewriteSession(rewriteSession);
                }
                if (this.fUndoManager != null) {
                    this.fUndoManager.endCompoundChange();
                }
                throw throwable;
            }
            if (d instanceof IDocumentExtension4) {
                IDocumentExtension4 extension = (IDocumentExtension4)d;
                extension.stopRewriteSession(rewriteSession);
            }
            if (this.fUndoManager != null) {
                this.fUndoManager.endCompoundChange();
            }
        }
    }
}

