/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.editor.ui.action;

import java.text.SimpleDateFormat;
import java.util.Date;
import jp.sourceforge.f77editorplugin.editor.preference.PreferenceManager;
import jp.sourceforge.f77editorplugin.editor.ui.FortranEditor;
import jp.sourceforge.f77editorplugin.editor.ui.action.EditorActionDelegate;
import jp.sourceforge.f77editorplugin.text.detectors.ILineDetector;
import jp.sourceforge.f77editorplugin.text.detectors.StatementLineDetector;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;

public class RevisionModifyAction
extends EditorActionDelegate
implements IPropertyChangeListener {
    private ILineDetector statementDetector = new StatementLineDetector();
    private static final String COMMENT_LETTER = "c";
    private static boolean disabled;
    private static String startTag;
    private static String endTag;
    private static SimpleDateFormat dateFormat;

    public RevisionModifyAction() {
        PreferenceManager.getStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.propertyChange(null);
    }

    public void propertyChange(PropertyChangeEvent event) {
        disabled = !PreferenceManager.getStore().getBoolean("editor.revisionComment.enable");
        dateFormat = new SimpleDateFormat(PreferenceManager.getStore().getString("editor.revisionComment.dateFormat"));
        startTag = PreferenceManager.getStore().getString("editor.revisionComment.modifyHeader");
        endTag = PreferenceManager.getStore().getString("editor.revisionComment.modifyFooter");
    }

    @Override
    public void run(IAction action) {
        IEditorPart editor = this.getActiveEditor();
        if (editor == null) {
            return;
        }
        if (editor instanceof FortranEditor) {
            FortranEditor fortranEditor = (FortranEditor)editor;
            try {
                TextSelection selection = (TextSelection)this.getSelection();
                if (selection != null && selection.getLength() > 0) {
                    this.editWithSelection(selection);
                } else {
                    this.editWithoutSelection(fortranEditor.getCaretOffset());
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    private String getDateString() {
        return dateFormat.format(new Date());
    }

    private String getStartTag() {
        return startTag.replace("%d", this.getDateString());
    }

    private String getEndTag() {
        return endTag.replace("%d", this.getDateString());
    }

    private void editWithoutSelection(int caretOffset) throws BadLocationException {
        IDocument doc = this.getDocument();
        int line = doc.getLineOfOffset(caretOffset);
        int offset = doc.getLineOffset(line);
        int length = doc.getLineLength(line);
        String delim = doc.getLineDelimiter(line);
        String str = doc.get(offset, length);
        StringBuffer buf = new StringBuffer();
        buf.append(String.valueOf(this.getStartTag()) + delim);
        buf.append(COMMENT_LETTER);
        buf.append(str);
        caretOffset = offset + buf.length();
        if (this.statementDetector.isLinePart((CharSequence)str)) {
            buf.append(str);
        }
        buf.append(String.valueOf(this.getEndTag()) + delim);
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        multiTextEdit.addChild((TextEdit)new ReplaceEdit(offset, length, buf.toString()));
        multiTextEdit.apply(doc);
        this.setSelection(caretOffset, 0);
    }

    private void editWithSelection(TextSelection selection) throws BadLocationException {
        IDocument doc = this.getDocument();
        int startLine = selection.getStartLine();
        int endLine = selection.getEndLine();
        int offset = doc.getLineOffset(startLine);
        int length = doc.getLineOffset(endLine) + doc.getLineLength(endLine) - offset;
        String delim = doc.getLineDelimiter(startLine);
        StringBuffer buf = new StringBuffer();
        StringBuffer newBuf = new StringBuffer();
        buf.append(String.valueOf(this.getStartTag()) + delim);
        int line = startLine;
        while (line < endLine + 1) {
            String str = doc.get(doc.getLineOffset(line), doc.getLineLength(line));
            buf.append(COMMENT_LETTER + str);
            if (this.statementDetector.isLinePart((CharSequence)str)) {
                newBuf.append(str);
            }
            ++line;
        }
        int caretOffset = doc.getLineOffset(startLine) + buf.length();
        buf.append(newBuf);
        buf.append(String.valueOf(this.getEndTag()) + delim);
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        multiTextEdit.addChild((TextEdit)new ReplaceEdit(offset, length, buf.toString()));
        multiTextEdit.apply(doc);
        this.setSelection(caretOffset, 0);
    }

    @Override
    public boolean isEnabled(ISelection selection) {
        return !disabled && selection instanceof TextSelection && ((TextSelection)selection).getLength() > 0;
    }
}

