/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.outline.internal;

import java.util.LinkedList;
import java.util.List;
import jp.sourceforge.f77editorplugin.outline.internal.OutlineElement;
import jp.sourceforge.f77editorplugin.outline.internal.OutlineTokenProvider;
import jp.sourceforge.f77editorplugin.outline.scanner.OutlineParserScanner;
import jp.sourceforge.f77editorplugin.outline.ui.OutlinePage;
import jp.sourceforge.f77editorplugin.text.TokenProvider;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class OutlineContentProvider
implements ITreeContentProvider {
    private final OutlinePage page;
    protected IPositionUpdater positionUpdater = new DefaultPositionUpdater("__f77_outline_segment");
    protected List<OutlineElement> contents;
    private OutlineParserScanner outlineScanner = new OutlineParserScanner();

    public OutlineContentProvider(OutlinePage page) {
        this.page = page;
    }

    protected void parse(IDocument document) {
        try {
            this.contents = this.createRootNodes(document);
            int i = 0;
            while (i < this.contents.size()) {
                OutlineElement node = this.contents.get(i);
                int end = i < this.contents.size() - 1 ? this.contents.get((int)(i + 1)).getPosition().offset - 1 : document.getLength();
                node.getPosition().length = end - node.getPosition().offset;
                document.addPosition("__f77_outline_segment", node.getPosition());
                this.createChildNodes(document, node);
                ++i;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        catch (BadPositionCategoryException e) {
            e.printStackTrace();
        }
    }

    private List<OutlineElement> createRootNodes(IDocument document) throws BadLocationException {
        ITypedRegion[] regions = document.getDocumentPartitioner().computePartitioning(0, document.getLength());
        LinkedList<OutlineElement> list = new LinkedList<OutlineElement>();
        int i = 0;
        while (i < regions.length) {
            ITypedRegion reg = regions[i];
            if (reg.getType().equals("__f77_statement")) {
                IToken t;
                this.outlineScanner.setRange(document, reg.getOffset(), reg.getLength());
                Object elem = null;
                while ((t = this.outlineScanner.nextToken()) != Token.EOF) {
                    String word;
                    if (OutlineTokenProvider.OUTLINE_ROOT.equals(t)) {
                        word = document.get(this.outlineScanner.getTokenOffset(), this.outlineScanner.getTokenLength());
                        list.add(new OutlineElement(word, (IRegion)reg, this.page.getOutlineInput()));
                        continue;
                    }
                    if (elem != null && TokenProvider.STATEMENT_BLOCKNAME.equals(t)) {
                        word = document.get(this.outlineScanner.getTokenOffset(), this.outlineScanner.getTokenLength());
                        list.peekLast().setName(word.replaceAll("[\\s/]+", ""));
                        break;
                    }
                    if (elem == null || !TokenProvider.STATEMENT_WORD.equals(t)) continue;
                    word = document.get(this.outlineScanner.getTokenOffset(), this.outlineScanner.getTokenLength());
                    list.peekLast().setWord(word);
                    break;
                }
            }
            ++i;
        }
        if (list.size() == 0) {
            list.add(this.createDefaultRootNode(document));
        }
        return list;
    }

    private OutlineElement createDefaultRootNode(IDocument document) {
        String word = "program";
        String name = "main";
        OutlineElement elem = new OutlineElement(word);
        elem.setName(name);
        elem.setPosition(new Position(0, document.getLength()));
        elem.setParent(this.page.getOutlineInput());
        return elem;
    }

    private void createChildNodes(IDocument document, OutlineElement parent) throws BadLocationException, BadPositionCategoryException {
        ITypedRegion[] regions = document.getDocumentPartitioner().computePartitioning(parent.getPosition().offset, parent.getPosition().length);
        LinkedList<OutlineElement> list = new LinkedList<OutlineElement>();
        int i = 0;
        while (i < regions.length) {
            ITypedRegion reg = regions[i];
            if (reg.getType().equals("__f77_statement")) {
                IToken t;
                this.outlineScanner.setRange(document, reg.getOffset(), reg.getLength());
                OutlineElement elem = null;
                while ((t = this.outlineScanner.nextToken()) != Token.EOF) {
                    String word;
                    if (OutlineTokenProvider.OUTLINE_CHILD.equals(t)) {
                        word = document.get(this.outlineScanner.getTokenOffset(), this.outlineScanner.getTokenLength());
                        elem = new OutlineElement(word, (IRegion)reg, this.page.getOutlineInput());
                        list.add(elem);
                        document.addPosition("__f77_outline_segment", elem.getPosition());
                        continue;
                    }
                    if (elem != null && TokenProvider.STATEMENT_BLOCKNAME.equals(t)) {
                        word = document.get(this.outlineScanner.getTokenOffset(), this.outlineScanner.getTokenLength());
                        list.peekLast().setName(word.replaceAll("[\\s/]+", ""));
                        break;
                    }
                    if (elem == null || !TokenProvider.STATEMENT_WORD.equals(t)) continue;
                    word = document.get(this.outlineScanner.getTokenOffset(), this.outlineScanner.getTokenLength());
                    list.peekLast().setWord(word);
                    break;
                }
            }
            ++i;
        }
        parent.addChildren(list);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        IDocument document;
        if (oldInput != null && (document = this.page.getDocumentProvider().getDocument(oldInput)) != null) {
            try {
                document.removePositionCategory("__f77_outline_segment");
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
            document.removePositionUpdater(this.positionUpdater);
        }
        if (this.contents != null) {
            this.contents.clear();
        }
        if (newInput != null && (document = this.page.getDocumentProvider().getDocument(newInput)) != null) {
            document.addPositionCategory("__f77_outline_segment");
            document.addPositionUpdater(this.positionUpdater);
            this.parse(document);
        }
    }

    public void dispose() {
        if (this.contents != null) {
            this.contents.clear();
            this.contents = null;
        }
    }

    public Object[] getElements(Object element) {
        return this.contents.toArray();
    }

    public boolean hasChildren(Object element) {
        if (element == this.page.getOutlineInput()) {
            return true;
        }
        if (element instanceof OutlineElement) {
            return ((OutlineElement)element).hasChildren();
        }
        return false;
    }

    public Object getParent(Object element) {
        if (element instanceof OutlineElement) {
            return ((OutlineElement)element).getParent();
        }
        return null;
    }

    public Object[] getChildren(Object element) {
        if (element == this.page.getOutlineInput()) {
            return this.contents.toArray();
        }
        if (element instanceof OutlineElement) {
            return ((OutlineElement)element).getChildren();
        }
        return new Object[0];
    }
}

