/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.outline.internal;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;

public class OutlineElement {
    private String title;
    private String name;
    private String word;
    private Position position;
    private Object parent;
    private Collection<OutlineElement> children = new LinkedList<OutlineElement>();

    public OutlineElement() {
    }

    public OutlineElement(String title) {
        this();
        this.title = title;
    }

    public OutlineElement(String title, IRegion region, Object parent) {
        this(title);
        this.setPosition(region);
        this.setParent(parent);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getType() {
        return this.title.toUpperCase();
    }

    public String getName() {
        return this.name != null ? this.name : "";
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getWord() {
        return this.word != null ? this.word : "";
    }

    public void setWord(String word) {
        this.word = word;
    }

    public Object getParent() {
        return this.parent;
    }

    public void setParent(Object parent) {
        this.parent = parent;
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public void setPosition(IRegion region) {
        this.position = new Position(region.getOffset(), region.getLength());
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public void addChild(OutlineElement node) {
        this.children.add(node);
    }

    public OutlineElement[] getChildren() {
        return this.children.toArray(new OutlineElement[this.children.size()]);
    }

    public void addChildren(Collection<OutlineElement> children) {
        this.children.addAll(children);
    }

    public String getImageKey() {
        return this.title.toLowerCase().replaceAll("[ ]+", "");
    }
}

