/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.outline.preference;

import java.util.HashMap;
import java.util.Map;
import jp.sourceforge.f77editorplugin.outline.Activator;
import jp.sourceforge.f77editorplugin.outline.internal.codec.OutlineWordItemCodec;
import jp.sourceforge.f77editorplugin.text.Messages;
import jp.sourceforge.f77editorplugin.text.preference.DefinitionWord;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class PreferenceManager
implements IPropertyChangeListener {
    private static PreferenceManager instance;
    protected Map<String, DefinitionWord> outlineWordMap;

    public static PreferenceManager getInstance() {
        if (instance == null) {
            instance = new PreferenceManager();
            PreferenceManager.getStore().addPropertyChangeListener((IPropertyChangeListener)instance);
        }
        return instance;
    }

    public void propertyChange(PropertyChangeEvent event) {
        PreferenceManager.getInstance().buildOutlineWordMap();
    }

    public static IPreferenceStore getStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    public Map<String, DefinitionWord> getWordMap() {
        if (this.outlineWordMap == null) {
            this.outlineWordMap = new HashMap<String, DefinitionWord>();
        }
        return this.outlineWordMap;
    }

    public void buildOutlineWordMap() {
        Map<String, DefinitionWord> m = this.getWordMap();
        OutlineWordItemCodec codec = new OutlineWordItemCodec(Messages.getBundle(), "Preference.Outline.Word.Category.");
        for (String[] item : codec.decode(PreferenceManager.getStore().getString("referenece.store.outlineWords"))) {
            DefinitionWord w = new DefinitionWord(DefinitionWord.Type.OUTLINEWORD, item);
            m.put(w.getKey(), w);
            if (!w.hasAlias()) continue;
            m.put(w.getAliasKey(), w);
        }
    }

    public void dispose() {
        PreferenceManager.getStore().removePropertyChangeListener((IPropertyChangeListener)instance);
    }

    public static interface Keys {
        public static final String STORE_OUTLINE_WORDS = "referenece.store.outlineWords";
    }
}

