/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.outline.preference.ui;

import jp.sourceforge.f77editorplugin.common.ui.dialog.ITableItemDialog;
import jp.sourceforge.f77editorplugin.common.ui.preference.MapTableFieldEditor;
import jp.sourceforge.f77editorplugin.outline.Messages;
import jp.sourceforge.f77editorplugin.outline.internal.codec.OutlineWordItemCodec;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class OutlineWordItemEditor
extends MapTableFieldEditor {
    public OutlineWordItemEditor(String name, String labelText, Composite parent, int width, int height, ITableItemDialog dialogFactory) {
        super(name, labelText, parent, width, height, dialogFactory);
    }

    protected void doLoad() {
        if (this.tableField != null) {
            TableColumn col = new TableColumn(this.tableField, 0);
            col.setText(Messages.getString("Preference.Outline.Word.WordColumn.label"));
            col.setWidth(this.widthHint / 2);
            col = new TableColumn(this.tableField, 0);
            col.setText(Messages.getString("Preference.Outline.Word.TypeColumn.label"));
            col.setWidth(this.widthHint / 2);
            col = new TableColumn(this.tableField, 0);
            col.setWidth(0);
            this.loadPreference(this.getPreferenceStore().getString(this.getPreferenceName()));
        }
    }

    protected void doLoadDefault() {
        this.tableField.removeAll();
        this.loadPreference(this.getPreferenceStore().getDefaultString(this.getPreferenceName()));
    }

    private void loadPreference(String preference) {
        OutlineWordItemCodec codec = new OutlineWordItemCodec(Messages.getBundle(), "Preference.Outline.Word.Category.");
        for (String[] item : codec.decode(preference)) {
            TableItem tableItem = new TableItem(this.tableField, 0);
            tableItem.setText(item);
        }
    }

    protected void doStore() {
        OutlineWordItemCodec codec = new OutlineWordItemCodec();
        TableItem[] tableItemArray = this.tableField.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            codec.put(tableItem.getText(0), tableItem.getText(2));
            ++n2;
        }
        this.getPreferenceStore().setValue(this.getPreferenceName(), codec.encode());
    }
}

