/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.builder;

import java.util.Map;
import jp.sourceforge.f77editorplugin.builder.compiler.CompilerFactory;
import jp.sourceforge.f77editorplugin.builder.compiler.ICompiler;
import jp.sourceforge.f77editorplugin.builder.exception.CompileException;
import jp.sourceforge.f77editorplugin.builder.internal.IErrorHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class F77SourceBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "jp.sourceforge.f77editorplugin.builder.f77Builder";
    private static final String MARKER_TYPE = "jp.sourceforge.f77editorplugin.builder.f77Problem";
    private CompilerFactory compilerFactory;

    private void addMarker(IFile file, String message, int lineNumber, int severity) {
        try {
            IMarker marker = file.createMarker(MARKER_TYPE);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", severity);
            if (lineNumber == -1) {
                lineNumber = 1;
            }
            marker.setAttribute("lineNumber", lineNumber);
        }
        catch (CoreException coreException) {}
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return null;
    }

    void compile(IResource resource) {
    }

    private void deleteMarkers(IFile file) {
        try {
            file.deleteMarkers(MARKER_TYPE, false, 0);
        }
        catch (CoreException coreException) {}
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        try {
            this.getProject().accept((IResourceVisitor)new ResourceVisitor());
        }
        catch (CoreException coreException) {}
    }

    private ICompiler getCompiler() {
        if (this.compilerFactory == null) {
            this.compilerFactory = CompilerFactory.newInstance();
        }
        return this.compilerFactory.newCompiler();
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        delta.accept((IResourceDeltaVisitor)new DeltaVisitor());
    }

    class DeltaVisitor
    implements IResourceDeltaVisitor {
        DeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            switch (delta.getKind()) {
                case 1: {
                    F77SourceBuilder.this.compile(resource);
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    F77SourceBuilder.this.compile(resource);
                }
            }
            return true;
        }
    }

    class ErrorHandler
    implements IErrorHandler {
        private IFile file;

        public ErrorHandler(IFile file) {
            this.file = file;
        }

        private void addMarker(CompileException e, int severity) {
            F77SourceBuilder.this.addMarker(this.file, e.getMessage(), e.getLineNumber(), severity);
        }

        @Override
        public void error(CompileException exception) throws CompileException {
            this.addMarker(exception, 2);
        }

        @Override
        public void fatalError(CompileException exception) throws CompileException {
            this.addMarker(exception, 2);
        }

        @Override
        public void warning(CompileException exception) throws CompileException {
            this.addMarker(exception, 1);
        }
    }

    class ResourceVisitor
    implements IResourceVisitor {
        ResourceVisitor() {
        }

        public boolean visit(IResource resource) {
            F77SourceBuilder.this.compile(resource);
            return true;
        }
    }
}

