/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.perspective.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewF77ProjectWizard
extends BasicNewResourceWizard {
    public static final String WIZARD_ID = "#F77NewProjectWizard";
    WizardNewProjectCreationPage projectNamePage;
    WizardNewProjectCreationPage propertyPage;

    public boolean performFinish() {
        try {
            WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) {
                    NewF77ProjectWizard.this.createProject((IProgressMonitor)(monitor != null ? monitor : new NullProgressMonitor()));
                }
            };
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException x) {
            this.reportError(x);
            return false;
        }
        catch (InterruptedException x) {
            this.reportError(x);
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
    }

    public void addPages() {
        super.addPages();
        this.projectNamePage = new WizardNewProjectCreationPage(WIZARD_ID);
        this.projectNamePage.setTitle("New Fortran Project");
        this.projectNamePage.setDescription("Create new Fortran project.");
        this.addPage((IWizardPage)this.projectNamePage);
    }

    protected void createProject(IProgressMonitor monitor) {
        monitor.beginTask("Create resources...", 50);
        try {
            try {
                monitor.subTask("Create directories...");
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IProject project = root.getProject(this.projectNamePage.getProjectName());
                IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(project.getName());
                if (!Platform.getLocation().equals((Object)this.projectNamePage.getLocationPath())) {
                    description.setLocation(this.projectNamePage.getLocationPath());
                }
                description.setNatureIds(this.getNatureIds());
                description.setBuildSpec(this.createBulderCommands(description));
                description.setReferencedProjects(this.getReferencedProjects());
                project.create(description, monitor);
                monitor.worked(10);
                project.open(monitor);
                monitor.worked(10);
            }
            catch (CoreException x) {
                this.reportError((Exception)((Object)x));
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private IProject[] getReferencedProjects() {
        return new IProject[0];
    }

    private String[] getNatureIds() {
        return new String[]{"jp.sourceforge.f77editorplugin.builder.f77Nature"};
    }

    private ICommand[] createBulderCommands(IProjectDescription description) {
        ICommand command = description.newCommand();
        command.setBuilderName("jp.sourceforge.f77editorplugin.builder.f77Builder");
        return new ICommand[]{command};
    }

    private void reportError(Exception x) {
        x.printStackTrace();
    }
}

