fcf.module({
  name: "fcfControls:templates/navigator.hooks.js",
  dependencies: [],
  module: function(){
    return {
      //
      // void hookBeforeBuild(a_taskInfo)
      // The hook is executed before assembling the template arguments
      //
      // hookBeforeBuild: function(a_taskInfo) {
      // },

      //
      // void hookAfterBuild(a_taskInfo)
      // The hook is executed after assembling the template arguments
      //
      // hookAfterBuild: function(a_taskInfo) {
      // },

      //
      // void hookAfterBuild(a_taskInfo)
      // The hook is executed after building the template's system arguments
      //
      // hookAfterSystemBuild: function(a_taskInfo) {
      // },

      //
      // Object of hooks for programmatically populated arguments
      //
      hooksProgramableArgument: {
        "items": function(a_taskInfo){
          let result = [];
          
          function clCalc(a_uri, a_cb){
            fcf.application.getRouter().getNode(a_uri)
            .then((a_nodeInfo)=>{
              if (!a_nodeInfo){
                a_cb();
                return;
              }
              if (a_nodeInfo.node.endpoint) {
                result.push({
                  title: a_nodeInfo.node.title ? a_nodeInfo.node.title : a_nodeInfo.node.endpoint.uri,
                  url:   a_uri,
                }); 
              }

              if (fcf.empty(a_nodeInfo.node.parent)){
                result = result.reverse();
                a_cb();
                return;
              }

              clCalc(a_nodeInfo.node.parent, a_cb);

            })

          }

          return fcf.actions().then((a_res, a_act)=>{
            clCalc(fcf.getContext().route.url, ()=>{
              a_act.complete(result);
            });
          });
        }
      },

      //
      // Object of the hooks preprocessing of the template arguments
      //
      // hooksBeforeArgument: {
      //   // 
      //   // @result Can return the value of an argument or Promise or undefined
      //   //
      //   "ARG_NAME": function(a_taskInfo) {
      //   }
      // },

      //
      // Object of the hooks postprocessing of the template arguments
      // hooksAfterArgument: {
      //   //
      //   // @result Can return the value of an argument or Promise or undefined
      //   //
      //   "ARG_NAME": function(a_taskInfo) {
      //   }
      // },
    };
  }
});
