fcf.module({
  name: "fcf:tests/NFSQL/DB.SelectFunctions.js",
  dependencies: ["fcf:NTest/uniTest.js", "fcf:tests/NFSQL/Helpers/Helper.js"],
  module: function(uniTest, Helper) {
    uniTest.add("FSQL DB" , "DB Select Functions", function(a_tester) {

      Helper.query(
        a_tester, { query: "select count() as count FROM fcftest_single_types1" },
        function(a_records){
          uniTest.equal(a_records, [[{"count": 2}]]);
        }
      );

      Helper.query(
        a_tester, { query: "select count() FROM fcftest_single_types1" },
        function(a_records){
          uniTest.equal(a_records, [[{"count()": 2}]]);
        }
      );

      Helper.query(
        a_tester, { query: "select key() FROM fcftest_single_types1" },
        function(a_records){
          uniTest.equal(a_records, [[{"key()": 1, "@key": 1},{"key()": 2, "@key": 2}]]);
        }
      );

      Helper.query(
        a_tester, { query: "select key() as key FROM fcftest_single_types1" },
        function(a_records){
          uniTest.equal(a_records, [[{"key": 1, "@key": 1},{"key": 2, "@key": 2}]]);
        }
      );

      Helper.query(
        a_tester, { query: "select concat(${1}, ${2}) as concat FROM fcftest_single_types1", args: ["1", "-2"] },
        function(a_records){
          uniTest.equal(a_records, [[{"concat": "1-2", "@key": 1},{"concat": "1-2", "@key": 2}]]);
        }
      );


      Helper.query(
        a_tester, { query: "select title() as title FROM fcftest_single_types1", args: [] },
        function(a_records){
          uniTest.equal(a_records, [[{ "title": "string_1 - test_1", "@key": 1 }, { "title": "string_2 - test_2", "@key": 2 }]]);
        }
      );

    });
  }
});
