fcf.module({
  name: "fcf:NServer/NControllers/Theme.js",
  dependencies: ["fcf:NServer/NControllers/Controller.js"],
  module: function(Controller){
    var Namespace = fcf.prepareObject(fcf, "packages/fcf/NServer/NControllers");
    fcf.addException("ERROR_THEME_NOT_FOUND", "Theme @{{theme}}@ not found");

    class Theme extends Controller{
      action(a_request) {
        let themeName = a_request.getRouteData().args.theme;
        if (!themeName)
          themeName = undefined;
        try { 
          let theme = fcf.application.getTheme(themeName);
          if (!theme)
            throw null;
          let decor   = theme.getDecor();
          let aliases = theme.getAliases();
          let views   = theme.getConfiguration().views;
          a_request.send({decor: decor, aliases: aliases, views: views});
        } catch (e){
          a_request.sendError(new fcf.Exception("ERROR_THEME_NOT_FOUND", {theme: themeName ? themeName : "default"}));
        }
      }
    };

    Namespace.Theme = Theme;

    return Namespace.Theme;
  }
});
