fcf.module({
  name: "fcfControls:templates/text-edit.wrapper.js",
  dependencies: ["fcfControls:templates/view.wrapper.js"],
  module: function(Wrapper){
    return class WrapperEx extends Wrapper {

      constructor(a_initializeOptions, a_disableAutoFill){
        super(a_initializeOptions);
        this._ignoreArgEvents = true;
        let element = fcf.select(this.getDomElement(), "input")[0];
        if (element){
          if (!a_disableAutoFill && fcf.str(this.getArg("value")) != fcf.str(element.value))
            this.setArg("value", element.value);
        }
        this._ignoreArgEvents = false;
      }

      onArg(a_name, a_value, a_editor, a_ignoreRedrawing, a_isInnerCall, a_suffix){
        if (this._ignoreArgEvents)
          return;
        if (!a_isInnerCall)
          this.update();
      }

      getActionDomElement() {
        return fcf.select(this.getDomElement(), "input")[0];
      }

      onInput(a_event){
        if (this.getArg("enable"))
          this._setArg("value", this.getActionDomElement().value);
        else
          this.getActionDomElement().value = this.getArg("value");
      }
    };
  }
});
