fcf.module({
  name: "fcfControls:templates/file-edit.wrapper.js",
  dependencies: ["fcfControls:templates/view.wrapper.js"],
  module: function(Wrapper){
    return class WrapperEx extends Wrapper{

      constructor(a_initializeOptions){
        super(a_initializeOptions);
        this._file = document.createElement("input");
        this._file.type = "file";
        this._file.addEventListener("change", (a_event)=>{ this.onFileChange(a_event); });
      }

      destroy(){
        super.destroy();
        this._file = null;
      }

      attach(){
        if (this._file.value)
          this._setArg("file",  this._file);
        return super.attach();
      }

      onArg(a_argName, a_value, a_editor, a_ignoreRedrawing, a_isInnerCall) {
        if (!a_isInnerCall && !this.isChild(a_editor))
          this.update();
        else 
          this.recalculate();
      }

      onFileSelect(){
        this._file.click();
      }

      onFileClear(a_event){
        this._setArg("file",  null);
        this._setArg("fileAlias", null);
        this._file.value = "";
        this.update();
      }

      onFileChange(a_event){
        let fileName = this.getArg("uniqueFileName")
                        ? fcf.getShortFileName(this._file.value)  + "-" + fcf.uuid() + (fcf.getExtension(this._file.value) ? "." + fcf.getExtension(this._file.value) : "")
                        : fcf.getFileName(this._file.value);
        this._file.name = fileName;
        this._file.path = fileName;
        this._file.setAttribute("filename", fileName);
        this._setArg("file", this._file);
        this._setArg("fileAlias", fcf.getFileName(this._file.value));
        this.update();
      }

    };
  }
});
