fcf.module({
  name: "fcfDBControls:templates/backRef-edit-full.wrapper.js",
  dependencies: ["fcf:NClient/Wrapper.js"],
  module: function(Wrapper){
    return class WrapperEx extends Wrapper{

      constructor(a_initializeOptions){
        super(a_initializeOptions);
        this._activeItems = {};
      }

      initialize(){
        return super.initialize();
      }

      validate(a_value, a_info, a_dsterrors) {
        let childs = this.getChilds();
        fcf.each(childs, (a_key, a_child) => {
          a_child.validate(typeof a_value == "object" ? a_value[a_key] : undefined, a_info, a_dsterrors);
        });
      }

      attach(){
        let self = this;
        let id = this.getId();
        fcf.each(this._activeItems, (a_key)=>{
          let container = fcf.select(`[name="folding"][owner="${id}"][key="${a_key}"]`)[0];
          if (container && !container.classList.contains("active")){
            self.onFoldItem(a_key);
          }
        });
        return super.attach();
      }

      processWritenValue(a_valuesInfo, a_defaultLanguage){
        let subValuesInfo = {};
        for(let lang in a_valuesInfo) {
          fcf.each(a_valuesInfo[lang].value, (a_index, a_value)=>{
            if (!subValuesInfo[a_index])
              subValuesInfo[a_index] = {};
            subValuesInfo[a_index][lang] = {
              value: a_value,
              ignore: false,
            }
          });
        }

        for(let index in subValuesInfo) {
          let child = this.getChild(index);
          if (!child)
            continue;
          child.processWritenValue(subValuesInfo[index], a_defaultLanguage);
        }

        for(let lang in a_valuesInfo){
          a_valuesInfo[lang] = {
            value: [],
            ignore: false,
          };
        }

        for(let index in subValuesInfo) {
          for(let lang in subValuesInfo[index]) {
            if (subValuesInfo[index][lang].ignore)
              continue;

            if (!a_valuesInfo[lang]){
              a_valuesInfo[lang] = {
                value: [],
                ignore: false,
              }
            }

            while (parseInt(index) >= a_valuesInfo[lang].value.length)
              a_valuesInfo[lang].value.push({})

            a_valuesInfo[lang].value[parseInt(index)] = subValuesInfo[index][lang].value;
          }
        }
      }

      onArg(a_argName, a_value, a_editor, a_ignoreRedrawing, a_isInnerCall, a_suffix) {
        if (a_argName.indexOf("value@")!=-1) {
          let lang = a_argName.substr("value@".length);
          let path = fcf.parseObjectAddress(a_suffix);
          if (path.length >= 2) {
            let form = this.getChild(path[0]);
            let field = form.getArg("fieldsMap")[path[1]];
            if (!field)
              return;
            let child = form.getChild(path[1]);
            if (!child)
              return;
            let multilingual = child && !!child.getArg("@language");

            if (!field.translate && !multilingual){
              fcf.each(this.getArg("@languages"), (a_lang)=>{
                if (lang == a_lang)
                  return;
                this.setArg(`value@${a_lang}${a_suffix}`, fcf.resolve(a_value, a_suffix));
              });
            }
          }
        }

        if (!this.isOwn(a_editor) && !a_isInnerCall)
          this.update();
      }

      onFoldItem(a_key){
        let id = this.getId();
        let container = fcf.select(`[name="folding"][owner="${id}"][key="${a_key}"]`)[0];
        let button = fcf.select(`[name="folding-button"][owner="${id}"][key="${a_key}"]`)[0];
        let title = fcf.select(`[name="folding-title"][owner="${id}"][key="${a_key}"]`)[0];
        if (container && !container.classList.contains("active")){
          container.classList.add("active");
          button.classList.add("active");
          title.classList.add("hidden");
          this._activeItems[a_key] = true;
        } else if (container){
          container.classList.remove("active");
          button.classList.remove("active");
          title.classList.remove("hidden");
          delete this._activeItems[a_key];
        }
      }

      onRemoveItem(a_key){
        if (this.getArg("@language")){
          fcf.each(this.getArg("@languages"), (a_lang)=>{
            let value = this.getArg(`value@${a_lang}`);
            value.splice(a_key, 1);
            this._setArg(`value@${a_lang}`, value);
          });
        } else {
          let value = this.getArg("value");
          value.splice(a_key, 1);
          this._setArg("value", value);
        }
        this.update();
      }

      onNewRecord() {
        if (this.getArg("@language")){
          let uuid = fcf.uuid();
          fcf.each(this.getArg("@languages"), (a_lang)=>{
            let value = this.getArg(`value@${a_lang}`);
            if (!Array.isArray(value))
              value = [];
            value.push({
              "@recorduuid": uuid,
            });
            this._setArg(`value@${a_lang}`, value);
          });
        } else {
          let value = this.getArg("value");
          if (!Array.isArray(value))
            value = [];
          value.push({});
          this._setArg("value", value);
        }
        this.update();
      }

    };
  }
});
