fcf.module({
  name: "fcf:tests/NFSQL/DB.Select.test.js",
  dependencies: ["fcf:NTest/uniTest.js", "fcf:tests/NFSQL/Helpers/Helper.js"],
  module: function(uniTest, Helper) {
    uniTest.add("FSQL DB" , "DB Select", function(a_tester) {

      Helper.query(
        a_tester, { query: "select str1, text1, int1, bigint1, bool1 FROM fcftest_single_types1" },
        function(a_records){
          uniTest.equal(a_records, [[
            { str1: 'string_1', text1: 'test_1', int1: 1, bigint1: 12, bool1: '1', "@key": 1 },
            { str1: 'string_2', text1: 'test_2', int1: 2, bigint1: 12, bool1: '1', "@key": 2 }
          ]]);
        }
      );

      Helper.query(
        a_tester, { query: "select str1, text1, int1, bigint1, bool1 FROM fcftest_single_types1 WHERE str1 = ${1}", args: ['string_2']},
        function(a_records){
          uniTest.equal(a_records, [[
            { str1: 'string_2', text1: 'test_2', int1: 2, bigint1: 12, bool1: '1', "@key": 2 }
          ]]);
        }
      );

      Helper.query(
        a_tester, { query: "select str1, text1, int1, bigint1, bool1 FROM fcftest_single_types1 WHERE int1 = ${1}", args: [1]},
        function(a_records){
          uniTest.equal(a_records, [[
            { str1: 'string_1', text1: 'test_1', int1: 1, bigint1: 12, bool1: '1', "@key": 1 },
          ]]);
        }
      );

      Helper.query(
        a_tester, { query: "select str1, text1, int1, bigint1, bool1 FROM fcftest_single_types1 LIMIT ${1} ", args: [1]},
        function(a_records){
          uniTest.equal(a_records, [[
            { str1: 'string_1', text1: 'test_1', int1: 1, bigint1: 12, bool1: '1', "@key": 1 },
          ]]);
        }
      )

      Helper.query(
        a_tester, { query: "select str1, text1, int1, bigint1, bool1 FROM fcftest_single_types1 ORDER BY str1 DESC LIMIT ${1}", args: [1]},
        function(a_records){
          uniTest.equal(a_records, [[
            { str1: 'string_2', text1: 'test_2', int1: 2, bigint1: 12, bool1: 1, "@key": 2 },
          ]]);
        }
      )

      Helper.query(
        a_tester, { query: "select str1, text1, int1, bigint1, bool1 FROM fcftest_single_types1 LIMIT ${1} OFFSET ${1} ", args: [1, 1]},
        function(a_records){
          uniTest.equal(a_records, [[
            { str1: 'string_2', text1: 'test_2', int1: 2, bigint1: 12, bool1: 1, "@key": 2 },
          ]]);
        }
      )

    });
  }
});
