fcf.module({
  name: "fcfControls:templates/multiselect.wrapper.js",
  dependencies: ["fcfControls:templates/view.wrapper.js"],
  module: function(Wrapper){
    return class WrapperEx extends Wrapper{

      constructor(a_initializeOptions){
        super(a_initializeOptions);
      }

      onSwitchElementAdd(event){
        this.getChild("select").setEnableButton("add", event.value != "");
      }

      onArgValue(a_value) {
        let data = {};
        let items = this.getArg("items");
        fcf.each(a_value, function(index, key){
          data[key] = items[key];
        });
        this.setArg("data", data);
        this.emit("change", {value: a_value, data: data});
      }

      onArgData(a_data) {
        let value = [];
        fcf.each(a_data, function(index, key){ value.push(index); });
        this.setArg("value", value, true);
        this.emit("change", {value: value, data: a_data});
      }

      onRemoveItem(a_event){
        var value = this.getArg("value");
        fcf.removeByValue(value, a_event.target.getAttribute("value"));
        this.setArg("value", value);
      }

      onAdd(event) {
        var keyAdd  = this.getChild("select").getArg("value");
        var dataAdd = this.getChild("select").getArg("data");
        var data    = this.getArg("data");
        var value   = this.getArg("value");
        if (fcf.find(data, function(k,v){ return fcf.equal(v, dataAdd); }) !== undefined)
          return;
        value.push(keyAdd);
        this.setArg("value", value);
      }

    };
  }
});
