fcf.module({
  name: "fcf:tests/NFSQL/DB.SelectSysJoin.js",
  dependencies: ["fcf:NTest/uniTest.js", "fcf:tests/NFSQL/Helpers/Helper.js"],
  module: function(uniTest, Helper) {
    uniTest.add("FSQL DB" , "DB Select System Join", function(a_tester) {

      Helper.query(
        a_tester, { query: "select str2, join_str, join_text, join_int FROM fcftest_single_types2" },
        function(a_records){
          uniTest.equal(a_records, [[
            {
              "str2": "string_2_1",
              "join_str": "string_1",
              "join_text": "test_1",
              "join_int": 1,
              "@key": 1
            },
            {
              "str2": "string_2_2",
              "join_str": "string_2",
              "join_text": "test_2",
              "join_int": 2,
              "@key": 2
            }
          ]]
        );
      });

      Helper.query(
        a_tester, { query: "select str2, join_str, join_text, join_int FROM fcftest_single_types2 LIMIT ${1} OFFSET ${2}", args: [1, 1] },
        function(a_records){
          uniTest.equal(a_records, [[
            {
              "str2": "string_2_2",
              "join_str": "string_2",
              "join_text": "test_2",
              "join_int": 2,
              "@key": 2
            }
          ]]
        );
      });

    });
  }
});
