fcf.module({
  name: "fcf:NFSQL/NFilter/Boolean.js",
  dependencies: ["fcf:NFSQL/NFilter/BaseSimpleType.js", "fcf:NFSQL/NFilter/Errors.js"],
  module: function(BaseSimpleType, Errors) {
    var NFilter = fcf.prepareObject(fcf, "NFSQL.NFilter");

    NFilter.Boolean = class Boolean extends BaseSimpleType {

      constructor() {
        super({type: "boolean"});
        this.comparisons = {
          "*": ["=", "<>", "<", "<=", ">", ">="],
        };
      }

      getRealFields(a_projection, a_fieldAlias){
        var field = fcf.append(true, {}, a_projection.fieldsMap[a_fieldAlias]);
        field.type = "int";
        return [field];
      }

      friendly(a_view, a_value){
        var values = Array.isArray(a_view.values) ? a_view.values : ["false", "true"];
        return a_value ? values[1] : values[0];
      }

      validate(a_description, a_dstErrors) {
        var value = a_description.data;
        var field = a_description.field;
        var from = a_description.projection ? a_description.projection.alias: "unknown";
        if ( value == "true" || (!isNaN(value) && !!value) ) {
          value = 1;
        } else if ( value == "false" || value == "0" || value == undefined) {
          value = 0;
        } else {
          a_dstErrors.push(new fcf.Exception("ERROR_NFSQL_INCORRECT_BOOLEAN_TYPE", {projection: from, field: field.alias, value: value}));
        }
      }

      insertFieldHandler(a_handler, a_queryObject, a_originQueryObject, a_container, a_key, a_originContainer, a_originKey){
        var f = a_container[a_key];
        var of = a_originContainer[a_originKey];
        var value = typeof of.value !== "string" || fcf.trim(of.value) != "" ? of.value : null;
        if ( value == "true" || (!isNaN(value) && !!value) ){
          f.value = 1;
        } else if ( value == "false" || value == "0" || value == undefined){
          f.value = 0;
        }
        this.checkModify(a_handler, a_queryObject, a_originQueryObject, a_container, a_key, a_originContainer, a_originKey);
      }

    }

    return NFilter.Boolean;
  }
});
