fcf.module({
  name: "fcfDBControls:templates/externalRef-edit.wrapper.js",
  dependencies: ["fcfControls:templates/view.wrapper.js"],
  module: function(Wrapper){
    return class ExternalRefEditWrapperEx extends Wrapper{
      
      constructor(a_initializeOptions){
        super(a_initializeOptions);
      }

      onArg (a_argName, a_value, a_editor, a_ignoreRedrawing, a_isInnerCall, a_suffix) {
        this.update();
      }

      onAppend(a_record){
        if (!a_record)
          return;
        let exist = false;
        let value = this.getArg("value");
        if (value === undefined)
          value = [];
        if (fcf.find(value, (a_key, a_rec)=>{return a_rec["@key"] == a_record["@key"]}) !== undefined)
          return;
        value.push(a_record);
        this.setArg("value", value)
        this.getChild("select").setArg("value", undefined);
      }

      onRemoveItem(a_event){
        let key   = a_event.target.getAttribute("value");
        let value = this.getArg("value");
        let index = fcf.find(value, (a_key, a_rec)=>{return a_rec["@key"] == key});
        if (index === undefined)
          return;
        value.splice(index, 1);
        this.setArg("value", value);
      }
    };
  }
});
