fcf.module({
  name: "fcfSimpleAuthorization:templates/registration-form.wrapper.js",
  dependencies: ["fcfControls:templates/form.wrapper.js"],
  module: function(Wrapper){

    fcf.addException("PASSWORD_DONT_MATCH", "Passwords don't match");

    return class WrapperEx extends Wrapper{
      
      constructor(a_initializeOptions){
        super(a_initializeOptions);
      }

      onArgError (a_value) {
        this.update();
      }

      registration(){
        let self = this;
        let errors = this.check();

        let password = this.getArg("value.password");
        let confirmPassword = this.getArg("value.confirm_password");
        if (!fcf.empty(password) && !fcf.empty(confirmPassword) && confirmPassword != password){
          errors.push({
            alias: "password",
            error: new fcf.Exception("PASSWORD_DONT_MATCH")
          });
        }

        if (!fcf.empty(errors)){
          this.setArg("errors", errors);
          this.setArg("error", undefined);
          return fcf.actions().error(new fcf.Exception("FAILD_FORM_INPUT"));
        }

        return this.send({ 
                            user: this.getArg("value.user"), 
                            email: this.getArg("value.email"), 
                            password: this.getArg("value.password") 
                          })
        .catch((a_error)=>{
          self.setArg("errors", errors);
          self.setArg("error", a_error);
        })
      }
    };
  }
});
