fcf.module({
  name: "fcf:NFSQL/NFilter/Enum.js",
  dependencies: ["fcf:NFSQL/NFilter/BaseSimpleType.js", "fcf:NFSQL/NFilter/Errors.js"],
  module: function(BaseSimpleType, Errors){
    var Namespace = fcf.prepareObject(fcf, "NFSQL.NFilter");

    class Enum extends BaseSimpleType{
      constructor(){
        super({type: "enum"});

        this.comparisons = {
          "*": ["=", "<>", "<", "<=", ">", ">="],
        };
      }

      validate(a_description, a_dstErrors) {
        var value = fcf.str(a_description.data);
        if ((a_description.field.notEmpty || a_description.field.notNull) && fcf.empty(value) ) {
          a_dstErrors.push(new fcf.Exception("ERROR_FIELD_VALIDATION_NOT_EMPTY"));
          return;
        }
      }
    };

    Namespace.Enum = Enum;

    return Namespace.Enum;
  }
});
