fcf.module({
  name: "fcf:NFSQL/NDetails/AutomateDelete.js",
  dependencies: ["fcf:NFSQL/NDetails/AutomateSingleField.js", "fcf:NFSQL/NDetails/AutomateSingleValue.js", "fcf:NFSQL/NDetails/AutomateWhere.js", "fcf:NFSQL/NDetails/AutomateLanguageItem.js"],
  module: function(AutomateSingleField, AutomateSingleValue) {
    var Automate = fcf.prepareObject(fcf, "NFSQL.NDetails.Automate");


    Automate.StepDelete = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.map["^{s}"] = null;
      this.map["^{nm}"] = { factory: "StepDelete_WaitFrom", skipFirst: false};
    }

    Automate.StepDelete_WaitFrom = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.map["^{nm}"] = null;
      this.map["^{nnm}"] = {map:{ "from": { factory: "StepSingleField", exit: "StepDelete_WaitWhere", dstValue: "from", skipFirst: false}, }};
    }

    Automate.StepDelete_WaitWhere = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.map["^{s}"] = null;
      this.map["^{nm}"] = { factory: "StepDelete_ReadWhere", skipFirst: false};
    }

    Automate.StepDelete_ReadWhere = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.map["^{nm}"] = null;
      this.map["^{nnm}"] = {map:{ 
                                "where": { factory: "StepWhere", skipFirst: false},
                                "language": {factory: "LanguageItem_SkipSpaces", skipFirst: false},
                              }};
    }

    return Automate;
  }
});
