fcf.module({
  name: "fcfControls:templates/button.wrapper.js",
  dependencies: ["fcfControls:templates/view.wrapper.js"],
  module: function(Wrapper){
    return class WrapperEx extends Wrapper{
      
      constructor(a_initializeOptions){
        super(a_initializeOptions);
      }

      onArg(a_name, a_value, a_editor, a_ignoreRedrawing, a_isInnerCall){
        this.update();
      }

      getActionDomElement(){
        return fcf.select(this.getDomElement(), "button")[0];
      }

      onArgTitle(a_value){
        this.getActionDomElement().innerHTML = a_value
      }

      onArgWidth(a_value){
        this.getActionDomElement().style.width = a_value;
      }

      onArgEnable(a_value){
        if (a_value)
          this.getActionDomElement().removeAttribute("disabled");
        else
          this.getActionDomElement().setAttribute("disabled", "disabled");
      }

    };
  }
});
