fcf.module({
  name: "fcf:NFSQL/NDetails/NConnections/MySQLBuilder.js",
  dependencies: ["fcf:NFSQL/NDetails/NConnections/BaseBuilder.js"],
  module: function(BaseBuilder) {
    var NConnections = fcf.prepareObject(fcf, "NFSQL.NDetails.NConnections");

    NConnections.MySQLBuilder = function(a_options) {

      BaseBuilder.call(this, a_options);

      this._buildField = function(a_result, a_fieldInfo) {
        var cast = undefined;
        if (a_fieldInfo.cast){
          cast = "string";
          a_result.query += "CONVERT(";
        }

        if (a_fieldInfo.from){
          this._buildSafeElement(a_result, a_fieldInfo.from);
          a_result.query += ".";
        }
        if (a_fieldInfo.field == "*")
          a_result.query += "*";
        else
          this._buildSafeElement(a_result, a_fieldInfo.field);

        if (cast) {
          a_result.query += ", CHAR)";
        }

      }

    }

    return NConnections.MySQLBuilder;
  }
});
