fcf.module({
  name: "fcf:NServer/NControllers/Theme.js",
  dependencies: ["fcf:NServer/NControllers/Controller.js"],
  module: function(Controller){
    var Namespace = fcf.prepareObject(fcf, "packages/fcf/NServer/NControllers");
    fcf.addException("ERROR_THEME_NOT_FOUND", "Theme @{{theme}}@ not found");

    class Theme extends Controller{

      getRequestInfo(){
        return {
          userRequest: false,
          redirect:    false,
        };
      }

      action(a_request) {
        let themeName = a_request.getRoute().args.theme;
        if (!themeName)
          themeName = undefined;
        try {
          let theme = fcf.application.getTheme(themeName);
          if (!theme)
            throw null;
          let decor       = theme.getDecor();
          let aliases     = theme.getAliases();
          let usageViews  = theme.getConfiguration().usageViews;
          a_request.send({decor: decor, aliases: aliases, usageViews: usageViews});
        } catch (e){
          a_request.sendError(new fcf.Exception("ERROR_THEME_NOT_FOUND", {theme: themeName ? themeName : "default"}));
        }
      }
    };

    Namespace.Theme = Theme;

    return Namespace.Theme;
  }
});
