fcf.module({
  name: "fcfManagement:templates/pages/system/sitemap+body.receive.js",
  dependencies: ["fcf:NSystem/Sitemap.js"],
  module: function(Sitemap){
    return class Handler {
      async receive(a_fields, a_files) {
        if (a_fields.command == "update_files") {
          await this.updateFiles();
        } else if (a_fields.command == "settings") {
          await this.setSettings(typeof a_fields.settings == "object" ? a_fields.settings : {});
        }
      }

      async setSettings(a_settings) {
        await fcf.application.setSystemVariable("fcf", "sitemapSettings", a_settings);
      }

      async updateFiles() {
        await fcf.application.getEventChannel().send("fcf_update_sitemap", {}, {endpoints:[{server: "*", processPair: 0}]});
      }

    }
  }
});
