fcf.module({
  name: "fcfManagement:templates/pages/system/sitemap+body.wrapper.js",
  dependencies: ["fcf:NClient/Wrapper.js"],
  module: function(Wrapper){
    return class WrapperEx extends Wrapper{

      constructor(a_initializeOptions){
        super(a_initializeOptions);
      }

      onArg(a_argName, a_value, a_editor, a_ignoreRedrawing, a_isInnerCall) {
        if (!this.getChild("save").getArg("enable")){
          this.getChild("save").setArg("enable", true);
          this.getChild("cancel").setArg("enable", true);
        }
      }

      onArgSettings(a_value, a_editor, a_ignoreRedrawing, a_innerCall, a_suffix){
        if (a_suffix == '["changefreqDefault"]'){
          let settings = this.getArg("settings");
          fcf.each(settings.sitemapItems,(k, a_item)=>{
            if (!a_item.changefreqCalc) {
              a_item.changefreqDefault = a_value.changefreqDefault;
              if (a_item.changefreqDefaultFlag)
                a_item.changefreq = a_value.changefreqDefault;
              }
          })
          this.setArg("settings.sitemapItems", settings.sitemapItems, true);
        } else if (a_suffix == '["priorityDefault"]'){
          let settings = this.getArg("settings");
          fcf.each(settings.sitemapItems,(k, a_item)=>{
            if (!a_item.priorityCalc) {
              a_item.priorityDefault = a_value.priorityDefault;
              if (a_item.priorityDefaultFlag)
                a_item.priority = a_value.priorityDefault;
            }
          })
          this.setArg("settings.sitemapItems", settings.sitemapItems, true);
        } else if (a_suffix == '["multilingualDefault"]'){
          let settings = this.getArg("settings");
          fcf.each(settings.sitemapItems,(k, a_item)=>{
            if (!a_item.multilingualCalc) {
              a_item.multilingualDefault = a_value.multilingualDefault;
              if (a_item.multilingualDefaultFlag)
                a_item.multilingual = a_value.multilingualDefault;
            }
          })
          this.setArg("settings.sitemapItems", settings.sitemapItems, true);
        }
      }

      attach(){
        return super.attach();
      }

      onUpdateFiles(){
        let self = this;
        self.lock();
        this.send({command: "update_files"})
        .finally(()=>{
          self.unlock();
        })
        .catch(()=>{
          fcf.application.getEventChannel().send("fcf_error", e);
        })
      }

      onSave(){
        let self = this;
        self.lock();
        this.send({command: "settings", settings: this.getArg("settings")})
        .then(()=>{
          return self.onCancel();
        })
        .finally(()=>{
          self.unlock();
        })
        .catch((error)=>{
          fcf.application.getEventChannel().send("fcf_error", error);
        })
      }


      onCancel(){
        let self = this;
        self.lock();

        return this.reload()
        .finally(()=>{
          self.unlock();
          this.getChild("save").setArg("enable", false);
          this.getChild("cancel").setArg("enable", false);
        })
        .catch(()=>{
          fcf.application.getEventChannel().send("fcf_error", e);
        })

      }

      onNewRecord(){
        let additionalSitemapItems = this.getArg("settings.additionalSitemapItems");
        if (!Array.isArray(additionalSitemapItems))
          additionalSitemapItems = [];
        additionalSitemapItems.unshift({
          url:              "",
          priority:         0.5,
          multilingual:     true,
          changefreq:       this.getChild("changefreqDefault").getArg("value"),
          enable:           true,
        });
        this.setArg("settings.additionalSitemapItems", additionalSitemapItems);
      }

      onRemoveRecord(a_index){
        let value = this.getArg("settings.additionalSitemapItems");
        value.splice(a_index, 1);
        this.setArg("settings.additionalSitemapItems", value);
      }
    };
  }
});
