fcf.module({
  name: "fcf:NFSQL/NDetails/AutomateSingleField.js",
  dependencies: [],
  module: function() {
    var Automate = fcf.prepareObject(fcf, "NFSQL.NDetails.Automate");

    Automate.StepSingleField = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.map["^{s}"] = null;
      this.map["^{nm}"] = { factory: "StepSingleField_Read", skipFirst: false};
      this.map["\""] = { factory: "StepSingleField_ReadQuotes", skipFirst: true};
      this.actionSwitch = function() {
        this.state.details.projection = {
          exit: this.state.details.stepInfo.exit,
          dstValue: this.state.details.stepInfo.dstValue,
        };
      }
    }

    Automate.StepSingleField_Read = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.map["^{nm}"] = null;
      this.map[""] = {factory: this.state.details.projection.exit, skipFirst: false};
      this.actionSwitch = function() {
        var ptr = fcf.resolveEx(this.state, this.state.details.projection.dstValue);
        if (Array.isArray(ptr.object[ptr.key]))
          ptr.object[ptr.key].push(this.buffer);
        else
          ptr.object[ptr.key] = this.buffer;
      }
    }

    Automate.StepSingleField_ReadQuotes = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.map[""] = null;
      this.map["\""] = {factory: this.state.details.projection.exit, skipFirst: true};
      this.actionSwitch = function() {
        var ptr = fcf.resolveEx(this.state, this.state.details.projection.dstValue);
        if (Array.isArray(ptr.object[ptr.key]))
          ptr.object[ptr.key].push(this.buffer);
        else
          ptr.object[ptr.key] = this.buffer;
      }
    }

    return Automate;
  }
});
