fcf.module({
  name: "fcf:tests/NFSQL/Parser.delete.test.js",
  dependencies: ["fcf:NTest/uniTest.js", "fcf:NFSQL/NDetails/SingleParser.js"],
  module: function(uniTest, Parser) {
    var NTests = fcf.prepareObject(fcf, "NFSQL.NTests");
    var parser = new Parser();

    uniTest.add("001 FSQL", "Parser (DELETE)", function(a_tester) {

      var data = parser.parse("DELETE FROM proj WHERE id = ${1}", [2]);
      uniTest.equalObject(
        data,
        {
          type: 'delete',
          from: 'proj',
          where: [{logic: "and", type: "=", args:[{field: "id"}, {value: 2}]}],
          args:  {"where[0].args[1].value": 1}
        },
        "");

      var data = parser.parse("DELETE FROM \"proj2\" WHERE \"id\" <> ${1} ", [3]);
      uniTest.equalObject(
        data,
        {
          type: 'delete',
          from: 'proj2',
          where: [{logic: "and", type: "<>", args:[{field: "id"}, {value: 3}]}],
          args:  {"where[0].args[1].value": 1}
        },
        "");

      var data = parser.parse("DELETE FROM\"proj2\"WHERE\"id\"<>${1} ", [3]);
      uniTest.equalObject(
        data,
        {
          type: 'delete',
          from: 'proj2',
          where: [{logic: "and", type: "<>", args:[{field: "id"}, {value: 3}]}],
          args:  {"where[0].args[1].value": 1}
        },
        "");

      var data = parser.parse("DELETE FROM\"proj2\"WHERE\"id\"<>${1} LANGUAGE en", [3]);
      uniTest.equalObject(
        data,
        {
          type: 'delete',
          from: 'proj2',
          where: [{logic: "and", type: "<>", args:[{field: "id"}, {value: 3}]}],
          language: "en",
          args:  {"where[0].args[1].value": 1}
        },
        "");

      var data = parser.parse("DELETE FROM\"proj2\"WHERE\"id\"<>${1}LANGUAGE en", [3]);
      uniTest.equalObject(
        data,
        {
          type: 'delete',
          from: 'proj2',
          where: [{logic: "and", type: "<>", args:[{field: "id"}, {value: 3}]}],
          language: "en",
          args:  {"where[0].args[1].value": 1}
        },
        "");

      var data = parser.parse("DELETE FROM\"proj2\"LANGUAGE en", [3]);
      uniTest.equalObject(
        data,
        {
          type: 'delete',
          from: 'proj2',
          where: [],
          language: "en",
          args:  {}
        },
        "");

      var data = parser.parse("DELETE FROM\"proj2\" LANGUAGE ${1}", ["en"]);
      uniTest.equalObject(
        data,
        {
          type: 'delete',
          from: 'proj2',
          where: [],
          language: "en",
          args:  {"language": 1}
        },
        "");

        var data = parser.parse("DELETE FROM\"proj2\" WHERE key() = ${1} LANGUAGE ${2}", [1, "en"]);
        uniTest.equalObject(
          data,
          {
            "args": { "where[0].args[1].value": 1, "language": 2 },
            "type": "delete",
            "from": "proj2",
            "where": [
              {
                "logic": "and",
                "args": [
                  { "function": "key", "args": [] },
                  { "value": 1 }
                ],
                "type": "="
              }
            ],
            "language": "en"
          },
          "");

    });

    return NTests;
  }
});
