fcf.module({
  name:         "fcfJodit:templates/jodit.wrapper.js",
  dependencies: ["fcf:NClient/Wrapper.js"],
  module: function(Wrapper){
    return class JoditWrapper extends Wrapper{

      constructor(a_initializeOptions) {
        super(a_initializeOptions);
        this._sizeObserver();
      }

      attach(a_options) {
        if (a_options.updateStatic || a_options.first){
          this._editor = this.getDomElement()._editor;
          this._editor.events.on('change', () => {
            this.onChange();
          });
        }
        this.onArgValue(this.getArg("value"), this);
        super.attach(a_options);
      }

      onArg(a_argName, a_value, a_editor, a_ignoreRedrawing, a_innerCall, a_suffix) {
        if (a_argName == "value" || a_innerCall)
          return;
        this.update({updateStatic: true});
      }

      onArgValue(a_value, a_editor, a_ignoreRedrawing, a_innerCall, a_suffix) {
        if (!a_innerCall) {
          let fe = document.activeElement;
          let oldIsSilentChange = this._editor.isSilentChange;
          this._editor.isSilentChange = true;
          this._editor.setEditorValue(a_value);
          this._editor.isSilentChange = oldIsSilentChange;
          if (fe) {
            fe.focus();
            setTimeout(()=>{ fe.blur(); fe.focus(); }, 1);
          }
        }
      }

      onChange() {
        this._setArg("value", this._editor.value);
      }

      _sizeObserver(){
        if (this._destroy)
          return;
        let self = this;
        let height = fcf.getRect(this.getDomElement()).height;
        if (height != this.getArg("height"))
          this._setArg("height", height);
        setTimeout(()=>{
          self._sizeObserver();
        }, 100);
      }

    };
  }
});
