fcf.module({
  name: "fcfManagement:templates/blocks/dialog.wrapper.js",
  dependencies: ["fcf:NClient/Wrapper.js"],
  module: function(Wrapper){
    return class WrapperEx extends Wrapper{

      constructor(a_initializeOptions){
        super(a_initializeOptions);
        let self = this;
        this._resizeCaller = function (a_event) { self.onResize(a_event); }
      }

      attach(a_options) {
        window.removeEventListener('resize', this._resizeCaller);
        window.addEventListener('resize', this._resizeCaller);
        this.onResize();
        super.attach(a_options);
      }

      onDestroy() {
        window.removeEventListener('resize', this._resizeCaller);
      }


      onResize() {
        let wpHeight = window.innerHeight;
        let wpWidth = window.innerWidth;
        let bodyMaxHeight = (wpHeight*0.9)-130;


        this.getDomElement().style.width = wpWidth;
        this.getDomElement().style.height = wpHeight;
        this.getDomElement().style.display = "table";

        let deBody = this.select("[name=body]")[0];
        deBody.style.maxHeight = bodyMaxHeight + "px";
      }

      onArg(a_argName, a_value, a_editor, a_ignoreRedrawing, a_isInnerCall, a_suffix) {
        this.update();
      }

      onButtonClick(a_button){
        let self = this;
        this.emit("close", {button: a_button})
        .then((a_event)=>{
          if (!a_event.stopDefault)
            self.destroy();
        });
      }



    };
  }
});
